//package com.xforceplus.ultraman.sdk.graphql.gen;
//
//import akka.grpc.javadsl.SingleResponseRequestBuilder;
//import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
//import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
//import com.xforceplus.ultraman.oqsengine.sdk.TransactionUp;
//import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionCreateErrorException;
//import graphql.ExecutionResult;
//import graphql.GraphQLContext;
//import graphql.execution.AsyncSerialExecutionStrategy;
//import graphql.execution.ExecutionContext;
//import graphql.execution.ExecutionStrategyParameters;
//import graphql.execution.NonNullableFieldWasNullException;
//import graphql.language.Directive;
//import graphql.language.OperationDefinition;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//
//import java.util.Collections;
//import java.util.List;
//import java.util.Optional;
//import java.util.UUID;
//import java.util.concurrent.CompletableFuture;
//
///**
// * TransactionExecutionStrategy
// */
//public class TransactionalExecutionStrategy extends AsyncSerialExecutionStrategy {
//
//    @Autowired
//    private EntityServiceClient entityServiceClient;
//
//    private Logger logger = LoggerFactory.getLogger(TransactionalExecutionStrategy.class);
//
//    @Override
//    public CompletableFuture<ExecutionResult> execute(
//            ExecutionContext executionContext
//            , ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
//
//        OperationDefinition operationDefinition = executionContext.getOperationDefinition();
//        List<Directive> directives = operationDefinition.getDirectives();
//        if (Optional.ofNullable(directives).orElseGet(Collections::emptyList).stream().anyMatch(x -> x.getName().equalsIgnoreCase(OqsTypesFactory.TRANSACTIONAL))) {
//            //transactional operation
//            String sticky = UUID.randomUUID().toString();
//            SingleResponseRequestBuilder<TransactionUp, OperationResult> builder = entityServiceClient
//                    .begin()
//                    .addHeader("sticky-session", sticky)
//                    .addHeader("timeout", "0");
//            OperationResult result =
//                    builder.invoke(TransactionUp.newBuilder().build())
//                            .toCompletableFuture().join();
//            if (result.getCode() != OperationResult.Code.OK) {
//                throw new TransactionCreateErrorException(result.getMessage());
//            } else {
//                logger.info("Transaction create success with id:{}", result.getTransactionResult());
//                String transactionResult = result.getTransactionResult();
//                Object context = executionContext.getContext();
//                if (context instanceof GraphQLContext) {
//                    ((GraphQLContext) context).put(OqsTypesFactory.TRANSACTIONAL, transactionResult);
//                    return super.execute(executionContext, parameters).thenApply(executionResult -> {
//                        if (!executionResult.getErrors().isEmpty()) {
//                            //rollback
//                            SingleResponseRequestBuilder<TransactionUp, OperationResult> request = entityServiceClient.rollBack();
//                            request.addHeader("sticky-session", sticky);
//                            request.invoke(TransactionUp.newBuilder().setId(transactionResult).build());
//                        } else {
//                            //commit
//                            SingleResponseRequestBuilder<TransactionUp, OperationResult> request = entityServiceClient.commit();
//                            request.addHeader("sticky-session", sticky);
//                            request.invoke(TransactionUp.newBuilder().setId(transactionResult).build());
//                        }
//                        return executionResult;
//                    });
//                } else {
//                    return super.execute(executionContext, parameters);
//                }
//            }
//        } else {
//            return super.execute(executionContext, parameters);
//        }
//    }
//}
