/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.sdk.graphql.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLSchemaHolder;
import com.xforceplus.ultraman.sdk.graphql.gen.BatchDataLoader;
import com.xforceplus.ultraman.sdk.infra.base.ExecutionConfig;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.spring.web.servlet.GraphQLInvocation;
import graphql.spring.web.servlet.GraphQLInvocationData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.WebRequest;

public class InnerGraphQLInvocation
implements GraphQLInvocation {
    @Autowired
    private GraphQLSchemaHolder holder;
    @Autowired
    private ProfileFetcher fetcher;
    @Autowired
    private ContextService contextService;
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private List<QueryProvider> queryProviders;
    public Map<String, Object> predicateMap;

    public InnerGraphQLInvocation(final ExecutionConfig executionConfig) {
        Predicate predicate = new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> aClass) {
                List skipRules = executionConfig.getSkipRules();
                return !skipRules.contains(aClass.getSimpleName());
            }
        };
        this.predicateMap = new HashMap<String, Object>();
        this.predicateMap.put("graphql.ParseAndValidate.Predicate", predicate);
    }

    public CompletableFuture<ExecutionResult> invoke(GraphQLInvocationData invocationData, WebRequest webRequest) {
        DataLoaderRegistry registry = new DataLoaderRegistry();
        this.engine.codes().forEach(code -> registry.computeIfAbsent(code, lazy -> DataLoaderFactory.newDataLoader((BatchLoaderWithContext)new BatchDataLoader(this.queryProviders))));
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(invocationData.getQuery()).graphQLContext(this.predicateMap).operationName(invocationData.getOperationName()).variables(invocationData.getVariables()).dataLoaderRegistry(registry).build();
        GraphQL graphQL = this.holder.getGraphQL(this.fetcher.getProfile(this.contextService.getAll()));
        CompletableFuture executionResultCompletableFuture = graphQL.executeAsync(executionInput);
        return executionResultCompletableFuture;
    }

    public Map<String, Object> getPredicateMap() {
        return this.predicateMap;
    }
}

