package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;

import java.util.Collections;
import java.util.List;

/**
 * condition builder
 */
public class ConditionBuilder implements ConditionNode{

    private String fieldName;

    private ConditionOp op;

    private List<?> values;

    public ConditionBuilder(String fieldName, ConditionOp op, List<?> values) {
        this.op = op;
        this.fieldName = fieldName;
        this.values = values;
    }

    public ConditionBuilder(String fieldName, ConditionOp op, Object t) {
        this.op = op;
        this.fieldName = fieldName;
        this.values = Collections.singletonList(t);
    }

    public String getFieldName() {
        return fieldName;
    }

//    public AndConditionBuilder and(ConditionBuilder nextCondition) {
//        andLink.add(nextCondition);
//        new
//        return this;
//    }

    public OrConditionBuilder or(ConditionBuilder nextCondition) {
        return new OrConditionBuilder(this, nextCondition);
    }

    public AndConditionBuilder and(ConditionBuilder nextCondition) {
        return new AndConditionBuilder(this, nextCondition);
    }

    public ConditionOp getOp() {
        return op;
    }

    public void setOp(ConditionOp op) {
        this.op = op;
    }

    public List<?> getValues() {
        return values;
    }

    public static <T> OperateStep<T> $(TypedField<T> field) {
        return new OperateStep<>(field);
    }

    public static <T> OperateStep<T> $(String code) {
        return new OperateStep<>(code);
    }
}
