package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static com.xforceplus.ultraman.sdk.core.rel.legacy.ExpOperator.*;

/**
 * query build factory
 */
public class QueryBuildFactory {

    private List<ConditionNode> conditionNodes;

    private SelectBuilder selectBuilder;

    private PageBuilder pageBuilder;

    private List<ConditionBuilder.OrderStep> orderSteps;

    public void setConditionNodes(List<ConditionNode> conditionNodes) {
        this.conditionNodes = conditionNodes;
    }

    public SelectBuilder getSelectBuilder() {
        return selectBuilder;
    }

    public void setSelectBuilder(SelectBuilder selectBuilder) {
        this.selectBuilder = selectBuilder;
    }

    public PageBuilder getPageBuilder() {
        return pageBuilder;
    }

    public void setPageBuilder(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    public List<ConditionBuilder.OrderStep> getOrderSteps() {
        return orderSteps;
    }

    public void setOrderSteps(List<ConditionBuilder.OrderStep> orderSteps) {
        this.orderSteps = orderSteps;
    }

    /**
     * deep traverse
     */
    private ExpNode traversal(ConditionNode conditionNode) {

        if (conditionNode instanceof ConditionBuilder) {
            ConditionBuilder conditionBuilder = (ConditionBuilder) conditionNode;
            //head node
            String fieldName = conditionBuilder.getFieldName();
            ConditionOp op = conditionBuilder.getOp();
            List<?> values = conditionBuilder.getValues();
            ExpCondition currentNode;
            if (values != null) {
                currentNode = ExpCondition.call(from(op)
                        , ExpField.field(fieldName)
                        , ExpValue.from(conditionBuilder.getValues()));
            } else {
                currentNode = ExpCondition.call(from(op)
                        , ExpField.field(fieldName));
            }
            return currentNode;
        } else if (conditionNode instanceof OrConditionBuilder) {
            //or node
            OrConditionBuilder orConditionBuilder = (OrConditionBuilder) conditionNode;
            List<ConditionNode> orList = orConditionBuilder.getOrList();
            List<ExpNode> orConditions = orList.stream().map(x -> traversal(x)).collect(Collectors.toList());
            return ExpCondition.call(OR, orConditions);
        } else if (conditionNode instanceof AndConditionBuilder) {
            //and node
            AndConditionBuilder andConditionBuilder = (AndConditionBuilder) conditionNode;
            List<ConditionNode> andList = andConditionBuilder.getAndList();
            List<ExpNode> andConditions = andList.stream().map(x -> traversal(x)).collect(Collectors.toList());
            return ExpCondition.call(AND, andConditions);
        }

        return ExpCondition.alwaysTrue();
    }

    public ExpRel build() {

        ExpQuery expQuery = new ExpQuery();

        List<ExpNode> nodes = new ArrayList<>();

        if (conditionNodes != null && !conditionNodes.isEmpty()) {
            /**
             * need to deep search
             */
            for (ConditionNode conditionNode : conditionNodes) {
                ExpCondition node = (ExpCondition) traversal(conditionNode);
                if (!node.isAlwaysTrue()) {
                    nodes.add(node);
                }
            }

            if (!nodes.isEmpty()) {
                expQuery.filters(nodes);
            }
        }

        if (selectBuilder != null) {
            List<String> items = selectBuilder.getItems();
            expQuery.project(items.stream()
                    .map(ExpField::field)
                    .collect(Collectors.toList()));
        }

        if (orderSteps != null && !orderSteps.isEmpty()) {
            List<ExpSort.FieldSort> sorts = orderSteps.stream().map(x -> new ExpSort.FieldSort(x.getFieldName()
                    , x.getOrder() == 0 ? ExpSort.Sort.ASCEND : ExpSort.Sort.DESCEND))
                    .collect(Collectors.toList());
            expQuery.sort(ExpSort.init()
                    .setSorts(sorts));
        }

        if (pageBuilder != null) {
            ExpRange range = new ExpRange(pageBuilder.getPageNo(), pageBuilder.getPageSize());
            expQuery.range(range);
        }

        return expQuery;
    }
}
