package com.xforceplus.ultraman.sdk.graphql.builder;

/**
 * query builder
 */
public class QueryBuilder {

    private String mainCode;

    private QueryBuildFactory factory;

    public QueryBuilder(String mainCode, QueryBuildFactory factory) {
        this.mainCode = mainCode;
        this.factory = factory;
    }

    /**
     * start from a entityCode
     * @param entityCode
     * @return
     */
    public static QueryBuilder from(String entityCode) {
        QueryBuildFactory factory = new QueryBuildFactory();
        QueryBuilder builder = new QueryBuilder(entityCode, factory);
        return builder;
    }

    public SelectBuilder select(String...names){
        return new SelectBuilder(factory, names);
    }
}
