package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * selectBuilder
 */
public class SelectBuilder {

    private List<String> items = new ArrayList<>();
    private QueryBuildFactory factory;

    public SelectBuilder(QueryBuildFactory factory, String...name){
        this.factory = factory;
        factory.setSelectBuilder(this);
        items.addAll(Arrays.asList(name));
    }

    public SelectBuilder(QueryBuildFactory factory, TypedField...typedFields) {
        this.factory = factory;
        factory.setSelectBuilder(this);
        items.addAll(Arrays.stream(typedFields)
                .map(TypedField::code)
                .collect(Collectors.toList()));
    }

    public List<String> getItems() {
        return items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public WhereBuilder where(List<ConditionNode> conditionBuilderList) {
        return new WhereBuilder(factory, conditionBuilderList);
    }

    public WhereBuilder where(ConditionNode...conditionBuilderList) {
        return new WhereBuilder(factory, Arrays.asList(conditionBuilderList));
    }
}
