package com.xforceplus.ultraman.sdk.graphql.builder;

import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;

import java.util.Arrays;
import java.util.List;

/**
 *
 */
public class WhereBuilder implements ExpBuilderLike {

    private QueryBuildFactory factory;

    public WhereBuilder(QueryBuildFactory factory, List<ConditionNode> conditionBuilderList) {
        factory.setConditionNodes(conditionBuilderList);
        this.factory = factory;
    }

    public PageBuilder orderBy(ConditionBuilder.OrderStep... orderStep) {
        factory.setOrderSteps(Arrays.asList(orderStep));
        return new PageBuilder(factory);
    }

    public PageBuilder pageNo(int pageNo) {
        return new PageBuilder(factory, pageNo);
    }

    @Override
    public ExpRel build() {
        return factory.build();
    }
}
