package com.xforceplus.ultraman.sdk.graphql.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.sdk.graphql.gen.OqsTypesFactory;
import com.xforceplus.ultraman.sdk.infra.Refreshable;
import graphql.GraphQL;
import graphql.execution.*;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.schema.GraphQLSchema;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.function.Consumer;

public class GraphQLSchemaHolder implements Refreshable {

    @Autowired
    private OqsTypesFactory typesFactory;

//    @Autowired
//    private TransactionalExecutionStrategy transactionalExecutionStrategy;

    @Autowired
    private AsyncExecutionStrategy asyncExecutionStrategy;

//    private Map<String, GraphQL> profiledGraphQLMap = new ConcurrentHashMap<>();

    private LoadingCache<String, GraphQL> l2Cache;

    public GraphQLSchemaHolder(){
        l2Cache = Caffeine.newBuilder()
                .maximumSize(1000)
                .build(key -> {
                    GraphQLSchema schema = typesFactory.genSchema(key);
                    DataLoaderDispatcherInstrumentationOptions options = DataLoaderDispatcherInstrumentationOptions
                            .newOptions().includeStatistics(true);

                    return GraphQL
                            .newGraphQL(schema)
                            //.mutationExecutionStrategy(transactionalExecutionStrategy)
                            .queryExecutionStrategy(asyncExecutionStrategy)
                            .instrumentation(new DataLoaderDispatcherInstrumentation(options))
                            .build();
                });
    }

    public OqsTypesFactory getTypesFactory() {
        return typesFactory;
    }

    public void setTypesFactory(OqsTypesFactory typesFactory) {
        this.typesFactory = typesFactory;
    }

    public GraphQL getGraphQL(String profile) {
       return l2Cache.get(profile);
    }

    public void clearAll(){
        l2Cache.invalidateAll();
    }

    @Override
    public void onRefresh(Object payload) {
        this.clearAll();
    }
}
