package com.xforceplus.ultraman.sdk.graphql.gen;

import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.QueryProvider;
import io.vavr.Tuple2;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

/**
 * batch data Loader
 */
public class BatchDataLoader implements BatchLoaderWithContext<Tuple2<IEntityClass, String>, Object> {

    final List<QueryProvider> queryProviders;

    public BatchDataLoader(List<QueryProvider> queryProviders) {
        this.queryProviders = queryProviders;
    }

    /**
     * batch loader only for related search one by one
     * @param keys
     * @param environment
     * @return
     */
    @Override
    public CompletionStage<List<Object>> load(List<Tuple2<IEntityClass, String>> keys, BatchLoaderEnvironment environment) {

        /**
         * do merge query
         */
        Map<IEntityClass, List<Tuple2<IEntityClass, String>>> grouping = keys.stream()
                .collect(Collectors.groupingBy(x -> x._1));

        Map<IEntityClass, List<String>> merged = new HashMap<>();
        grouping.forEach((k,v) -> {
            List<String> ids = v.stream().map(x -> x._2()).collect(Collectors.toList());
            merged.put(k, ids);
        });

        Optional<Map.Entry<IEntityClass, List<String>>> first = merged.entrySet().stream().findFirst();
        if(first.isPresent()) {
            Map.Entry<IEntityClass, List<String>> entry = first.get();
            List<String> value = entry.getValue();
            IEntityClass key = entry.getKey();

            Optional<QueryProvider> provider = queryProviders.stream().filter(x -> x.accept(key)).findFirst();
            if(provider.isPresent()) {
                return provider.get().batchQuery(key, value);
            } else {
                throw new RuntimeException("No suitable Batch Query for entity " + key.code());
            }
        } else {
            throw new RuntimeException("Size not ok");
        }
    }
}
