package com.xforceplus.ultraman.sdk.graphql.input;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;

import static graphql.Scalars.GraphQLString;
import static graphql.scalars.ExtendedScalars.DateTime;

public class DateTimeFilter {

    public static GraphQLInputType INSTANCE;

    static {
        INSTANCE = GraphQLInputObjectType.newInputObject()
                .name("DateTimeFilter")
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("eq")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("ge")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("gt")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("lt")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("le")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("ne")
                        .type(DateTime)
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("ni")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("in")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("ge_le")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("ge_lt")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("gt_le")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("gt_lt")
                        .type(GraphQLList.list(DateTime))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("nil")
                        .type(GraphQLList.list(GraphQLString))
                        .build())
                .field(GraphQLInputObjectField
                        .newInputObjectField()
                        .name("exists")
                        .type(GraphQLList.list(GraphQLString))
                        .build())
                .build();
    }
}
