package com.xforceplus.ultraman.sdk.graphql.gen;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * custom oqsInstrumentation
 */
public class OqsInstrumentation extends SimpleInstrumentation {

    @Override
    public CompletableFuture<ExecutionResult> instrumentExecutionResult(
            ExecutionResult executionResult,
            InstrumentationExecutionParameters parameters) {
        Map<Object, Object> currentExt = executionResult.getExtensions();
        Map<Object, Object> newExtensionMap = new LinkedHashMap<>();
        newExtensionMap.putAll(currentExt == null ? Collections.emptyMap() : currentExt);

        Object data = executionResult.getData();

        return CompletableFuture.completedFuture(
                new ExecutionResultImpl(
                        data,
                        executionResult.getErrors(),
                        newExtensionMap));
    }

}
