//package com.xforceplus.ultraman.sdk.controller;
//
//import com.alibaba.fastjson.JSON;
//import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
//import com.xforceplus.ultraman.oqsengine.pojo.dto.UltPage;
//import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
//import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
//import com.xforceplus.ultraman.oqsengine.sdk.service.PageService;
//import com.xforceplus.ultraman.oqsengine.sdk.store.PageBoMapLocalStore;
//import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.UltPageBoItem;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.apache.metamodel.data.DataSet;
//import org.apache.metamodel.data.Row;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.util.StringUtils;
//import org.springframework.web.client.RestTemplate;
//
//import javax.naming.directory.NoSuchAttributeException;
//import java.util.ArrayList;
//import java.util.List;
//import java.util.stream.Collectors;
//
///**
// * ult page setting controller
// */
//@Api(value = "/", tags = "页面配置操作")
//@RequestMapping
//public class UltPageSettingController {
//
//    @Autowired(required = false)
//    private RestTemplate restTemplate;
//
//    @Autowired(required = false)
//    private PageBoMapLocalStore pageBoMapLocalStore;
//
//    private final AuthConfig config;
//
//    public UltPageSettingController(AuthConfig config) {
//        this.config = config;
//    }
//
//    @Autowired(required = false)
//    private PageService pageService;
//
//    /**
//     * 部署页面
//     *
//     * @return
//     */
//    @ApiOperation(value = "部署页面")
//    @PostMapping("/pages/{id}/deployments")
//    @ResponseBody
//    public ResponseEntity deploymentsPage(
//            @ApiParam(value = "页面ID") @PathVariable String id
//    ) throws NoSuchAttributeException {
//
//        Response<List<UltPage>> result = initSettings(id);
//        if ("0".equals(result.getCode())) {
//            return ResponseEntity.ok(result);
//        }
//        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(result);
//    }
//
//    /**
//     * 获取页面bo列表
//     *
//     * @return
//     */
//    @ApiOperation(value = "获取页面bo列表")
//    @GetMapping("/pages/{id}/bo-settings")
//    @ResponseBody
//    public ResponseEntity pageBos(
//            @ApiParam(value = "页面ID") @PathVariable String id,
//            @ApiParam(value = "租户Code") @RequestParam(value = "tenantCode", required = false) String tenantCode
//    ) {
//        Response<ResponseList<UltPageBoItem>> response = new Response<>();
//        if (!StringUtils.isEmpty(id)) {
//            ResponseList<UltPageBoItem> items = getPageBos(id, tenantCode);
//            if (items.size() > 0) {
//                response.setMessage("查询成功");
//                response.setCode("200");
//                response.setResult(items);
//                return ResponseEntity.ok(response);
//            } else {
//                try {
//                    Response<List<UltPage>> result = initSettings(id);
//                    if (result.getResult().size() > 0) {
//                        items = getPageBos(id, tenantCode);
//                    }
//                    if (items.size() > 0) {
//                        response.setMessage("查询成功");
//                        response.setCode("200");
//                        response.setResult(items);
//                        return ResponseEntity.ok(response);
//                    } else {
//                        response.setMessage("查询无结果");
//                        response.setCode("-1");
//                        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//                    }
//                } catch (Exception e) {
//                    response.setMessage("查询无结果");
//                    response.setCode("-1");
//                    return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//                }
//            }
//
//        } else {
//            response.setMessage("未传id");
//            response.setCode("-1");
//            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//        }
//    }
//
//    /**
//     * 根据页面Code获取页面bo列表
//     *
//     * @return
//     */
//    @ApiOperation(value = "根据页面Code获取页面bo列表")
//    @GetMapping("/page-codes/{code}/bo-settings")
//    @ResponseBody
//    public ResponseEntity pageBosByCode(
//            @ApiParam(value = "页面Code") @PathVariable String code,
//            @ApiParam(value = "租户Code") @RequestParam(value = "tenantCode", required = false) String tenantCode
//    ) {
//        Response<ResponseList<UltPageBoItem>> response = new Response<>();
//        if (!StringUtils.isEmpty(code)) {
//            List<UltPageBoItem> items = pageService.findPageBos(code, tenantCode);
//            if (items.size() > 0) {
//                response.setMessage("查询成功");
//                response.setCode("200");
//                response.setResult((ResponseList<UltPageBoItem>) items);
//                return ResponseEntity.ok(response);
//            } else {
//                response.setMessage("查询无结果");
//                response.setCode("-1");
//                return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//            }
//
//        } else {
//            response.setMessage("未传Code");
//            response.setCode("-1");
//            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//        }
//    }
//
//    /**
//     * 根据业务对象id获取详细json配置
//     *
//     * @return
//     */
//    @ApiOperation(value = "根据业务对象id获取详细json配置")
//    @GetMapping("/bo-settings/{id}")
//    @ResponseBody
//    public ResponseEntity pageBoSettings(
//            @ApiParam(value = "元数据对象Id") @PathVariable String id
//    ) {
//
//        DataSet ds = null;
//        Response<UltPageBoItem> response = new Response<>();
//        if (!StringUtils.isEmpty(id)) {
//            ds = pageBoMapLocalStore.query().selectAll()
//                    .where("settingId")
//                    .eq(id)
//                    .execute();
//
//            List<Row> rows = ds.toRows();
//            ResponseList<UltPageBoItem> items = rows.stream().map(this::toUltPageBoSeeting).collect(Collectors.toCollection(ResponseList::new));
//            if (items.size() >= 1) {
//                response.setResult(items.get(0));
//                response.setMessage("查询成功");
//                response.setCode("1");
//            } else {
//                //存在未同步的配置，进行二次同步配置信息
//                try {
//                    initPages();
//                    ds = pageBoMapLocalStore.query().selectAll()
//                            .where("settingId")
//                            .eq(id)
//                            .execute();
//
//                    rows = ds.toRows();
//                    items = rows.stream().map(this::toUltPageBoSeeting).collect(Collectors.toCollection(ResponseList::new));
//                    if (items.size() >= 1) {
//                        response.setResult(items.get(0));
//                        response.setMessage("查询成功");
//                        response.setCode("1");
//                    } else {
//                        response.setMessage("查询无结果");
//                        response.setCode("-1");
//                        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//                    }
//                } catch (Exception e) {
//                    response.setMessage("查询无结果");
//                    response.setCode("-1");
//                    return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//                }
//            }
//            return ResponseEntity.ok(response);
//
//        } else {
//            response.setMessage("未传id");
//            response.setCode("-1");
//            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//        }
//    }
//
//    private Response initSettings(String id) {
//        String accessUri = ExternalServiceConfig.PfcpAccessUri();
//        String url = String.format("%s/pages/%s/deployments"
//                , accessUri
//                , id);
//        Authorization auth = new Authorization();
//        auth.setAppId(Long.parseLong(config.getAppId()));
////        auth.setTenantId(Long.parseLong(config.getTenant()));
//        auth.setEnv(config.getEnv());
//        Response<List<UltPage>> result = new Response<List<UltPage>>();
//        try {
//            result = restTemplate.postForObject(url, auth, Response.class);
//            if (result.getResult() != null) {
//                List<UltPage> ultPages = result.getResult();
//                for (int i = 0; i < ultPages.size(); i++) {
//                    UltPage saveUltPage = JSON.parseObject(JSON.toJSONString(ultPages.get(i)), UltPage.class);
//                    pageBoMapLocalStore.save(saveUltPage);
//                }
//            }
//            return result;
//        } catch (Exception e) {
//            result.setCode("400");
//            result.setMessage("部署失败");
//            return result;
//        }
//    }
//
//    private Response initPages() {
//        String accessUri = ExternalServiceConfig.PfcpAccessUri();
//        String url = String.format("%s/pages/init"
//                , accessUri);
//        Authorization auth = new Authorization();
//        auth.setAppId(Long.parseLong(config.getAppId()));
//        auth.setEnv(config.getEnv());
//        Response<List<UltPage>> result = new Response<List<UltPage>>();
//        try {
//            HttpHeaders headers = new HttpHeaders();
//            MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
//            headers.setContentType(type);
//            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
//            HttpEntity authorizeEntity = new HttpEntity(auth, headers);
//            result = restTemplate.postForObject(url, authorizeEntity, Response.class);
//            if (result.getResult() != null) {
//                List<UltPage> ultPages = result.getResult();
//                for (int i = 0; i < ultPages.size(); i++) {
//                    UltPage saveUltPage = JSON.parseObject(JSON.toJSONString(ultPages.get(i)), UltPage.class);
//                    pageBoMapLocalStore.save(saveUltPage);
//                }
//            }
//            return result;
//        } catch (Exception e) {
//            result.setCode("400");
//            result.setMessage("获取配置失败");
//            return result;
//        }
//    }
//
//    private ResponseList getPageBos(String id, String tenantCode) {
//        DataSet ds = null;
//        if (!StringUtils.isEmpty(id)) {
//            List<Row> trows = new ArrayList<>();
//            if (!StringUtils.isEmpty(tenantCode)) {
//                ds = pageBoMapLocalStore.query().selectAll()
//                        .where("refPageId")
//                        .eq(id)
//                        .and("tenantCode")
//                        .eq(tenantCode).orderBy("sortPlace").asc()
//                        .execute();
//                trows = ds.toRows();
//            }
//            if (ds != null && trows != null && trows.size() > 0) {
//                ResponseList<UltPageBoItem> items = trows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            } else {
//                ds = pageBoMapLocalStore.query().selectAll()
//                        .where("id")
//                        .eq(id).orderBy("sortPlace").asc()
//                        .execute();
//                List<Row> rows = ds.toRows();
//                ResponseList<UltPageBoItem> items = rows.stream().map(this::toUltPageBos).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            }
//        } else {
//            return null;
//        }
//    }
//
//    private ResponseList getSettings(String id) {
//        DataSet ds = null;
//        if (!StringUtils.isEmpty(id)) {
//            Response<UltPageBoItem> response = new Response<>();
//            ds = pageBoMapLocalStore.query().selectAll()
//                    .where("settingId")
//                    .eq(id)
//                    .execute();
//
//            List<Row> rows = ds.toRows();
//            ResponseList<UltPageBoItem> items = rows.stream().map(this::toUltPageBoSeeting).collect(Collectors.toCollection(ResponseList::new));
//            return items;
//
//        } else {
//            return null;
//        }
//    }
//
//    private UltPageBoItem toUltPageBos(Row row) {
//        UltPageBoItem ultPageBoItem = new UltPageBoItem();
//        ultPageBoItem.setId(Long.parseLong(RowUtils.getRowValue(row, "settingId").map(Object::toString).orElse("")));
//        ultPageBoItem.setPageId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
//        ultPageBoItem.setBoCode(RowUtils.getRowValue(row, "boCode").map(Object::toString).orElse(""));
//        if (!"".equals(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))) {
//            ultPageBoItem.setTenantId(Long.parseLong(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse("")));
//        }
//        if (!"".equals(RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse(""))) {
//            ultPageBoItem.setTenantCode((RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse("")));
//        }
//        ultPageBoItem.setTenantName(RowUtils.getRowValue(row, "tenantName").map(Object::toString).orElse(""));
//        ultPageBoItem.setBoName(RowUtils.getRowValue(row, "boName").map(Object::toString).orElse(""));
//        ultPageBoItem.setRemark(RowUtils.getRowValue(row, "remark").map(Object::toString).orElse(""));
//        if (!"".equals(RowUtils.getRowValue(row, "sortPlace").map(Object::toString).orElse(""))) {
//            ultPageBoItem.setSortPlace(Long.parseLong(RowUtils.getRowValue(row, "sortPlace").map(Object::toString).orElse("")));
//        }
//        ultPageBoItem.setEnvStatus(RowUtils.getRowValue(row, "envStatus").map(Object::toString).orElse(""));
//        ultPageBoItem.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
//        return ultPageBoItem;
//    }
//
//    private UltPageBoItem toUltPageBoSeeting(Row row) {
//        UltPageBoItem ultPageBoItem = new UltPageBoItem();
//        ultPageBoItem.setId(Long.parseLong(RowUtils.getRowValue(row, "settingId").map(Object::toString).orElse("")));
//        ultPageBoItem.setPageId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
//        ultPageBoItem.setBoCode(RowUtils.getRowValue(row, "boCode").map(Object::toString).orElse(""));
//        ultPageBoItem.setBoName(RowUtils.getRowValue(row, "boName").map(Object::toString).orElse(""));
//        ultPageBoItem.setSetting(RowUtils.getRowValue(row, "setting").map(Object::toString).orElse(""));
//        ultPageBoItem.setRemark(RowUtils.getRowValue(row, "remark").map(Object::toString).orElse(""));
//        if (!"".equals(RowUtils.getRowValue(row, "sortPlace").map(Object::toString).orElse(""))) {
//            ultPageBoItem.setSortPlace(Long.parseLong(RowUtils.getRowValue(row, "sortPlace").map(Object::toString).orElse("")));
//        }
//        ultPageBoItem.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
//        ultPageBoItem.setEnvStatus(RowUtils.getRowValue(row, "envStatus").map(Object::toString).orElse(""));
//        return ultPageBoItem;
//    }
//
//}
