package com.xforceplus.ultraman.sdk.controller.config;

import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.cdc.adapter.impl.NoOpAdapter;
import com.xforceplus.ultraman.oqsengine.plus.devops.DevOpsService;
import com.xforceplus.ultraman.oqsengine.plus.devops.RebuildDevOpsService;
import com.xforceplus.ultraman.oqsengine.plus.devops.storage.SQLTaskStorage;
import com.xforceplus.ultraman.sdk.infra.base.thread.ExecutorHelper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Configuration
public class RebuildIndexAutoConfiguration {

    @Bean
    public SQLTaskStorage sqlTaskStorage(@Qualifier("master") DataSource ds) {
        return new SQLTaskStorage(ds);
    }


    @Bean
    @ConditionalOnMissingBean(EngineAdapterService.class)
    public EngineAdapterService engineAdapterService() {
        return new NoOpAdapter();
    }

    @Bean
    public DevOpsService rebuildDevOpsService(
            @Value("${xplat.oqsengine.rebuild.query.size:1024}") int querySize,
            @Value("${xplat.oqsengine.rebuild.pool:5}") int worker,
            @Value("${xplat.oqsengine.rebuild.queue:500}") int queue) {

        int useWorker = worker;
        int useQueue = queue;
        if (useWorker == 0) {
            useWorker = Runtime.getRuntime().availableProcessors() + 1;
        } else {
            useWorker += 1;
        }

        if (useQueue < 500) {
            useQueue = 500;
        }

        ExecutorService executorService = buildThreadPool(useWorker, useQueue, "oqs-rebuild", false);

        return new RebuildDevOpsService(querySize, executorService);
    }

    private ExecutorService buildThreadPool(int worker, int queue, String namePrefix, boolean daemon) {
        return new ThreadPoolExecutor(worker, worker,
                0L, TimeUnit.MILLISECONDS,
                new ArrayBlockingQueue<>(queue),
                ExecutorHelper.buildNameThreadFactory(namePrefix, daemon),
                new ThreadPoolExecutor.AbortPolicy()
        );
    }
}
