//package com.xforceplus.ultraman.sdk.controller;
//
//import com.alibaba.fastjson.JSON;
//import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
//import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
//import com.xforceplus.ultraman.oqsengine.sdk.config.AuthConfig;
//import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
//import com.xforceplus.ultraman.oqsengine.sdk.store.FormBoMapLocalStore;
//import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
//import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.apache.metamodel.data.DataSet;
//import org.apache.metamodel.data.Row;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.HttpStatus;
//import org.springframework.http.ResponseEntity;
//import org.springframework.util.StringUtils;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.client.RestTemplate;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.stream.Collectors;
//
///**
// * ultform controller
// */
//@Api(value = "/", tags = "表单配置操作")
//@RequestMapping
//public class UltFormSettingController {
//
//    @Autowired(required = false)
//    private RestTemplate restTemplate;
//
//    @Autowired(required = false)
//    private FormBoMapLocalStore formBoMapLocalStore;
//
//    private final AuthConfig config;
//
//    public UltFormSettingController(AuthConfig config) {
//        this.config = config;
//    }
//
//    /**
//     * 部署动态表单
//     *
//     * @return
//     */
//    @ApiOperation(value = "部署表单")
//    @PostMapping("/form-settings/{id}/deployments")
//    @ResponseBody
//    public ResponseEntity deploymentsForm(
//            @ApiParam(value = "表单ID") @PathVariable String id
//    ) {
//        Response<List<UltForm>> result = initSettings(id);
//        if ("0".equals(result.getCode())) {
//            return ResponseEntity.ok(result);
//        }
//        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(result);
//    }
//
//    /**
//     * 根据表单id获取详细json配置
//     *
//     * @return
//     */
//    @ApiOperation(value = "根据表单id获取详细json配置")
//    @GetMapping("/form-settings/{id}")
//    @ResponseBody
//    public ResponseEntity pageBoSettings(
//            @ApiParam(value = "表单ID") @PathVariable String id,
//            @ApiParam(value = "租户Code") @RequestParam(value = "tenantCode", required = false) String tenantCode) {
//
//        Response<UltForm> response = new Response<>();
//        if (!StringUtils.isEmpty(id)) {
//            ResponseList<UltForm> items = getSettings(id, tenantCode);
//            if (items.size() == 1) {
//                response.setMessage("查询成功");
//                response.setCode("200");
//                response.setResult(items.get(0));
//                return ResponseEntity.ok(response);
//            } else {
//                Response<List<UltForm>> result = initSettings(id);
//                if (result.getResult().size() > 0) {
//                    items = getSettings(id, tenantCode);
//                }
//                if (items.size() == 1) {
//                    response.setMessage("查询成功");
//                    response.setCode("200");
//                    response.setResult(items.get(0));
//                    return ResponseEntity.ok(response);
//                } else {
//                    response.setMessage("菜单未部署");
//                    response.setCode("400");
//                    return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//                }
//            }
//        } else {
//            response.setMessage("未传id");
//            response.setCode("400");
//            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//        }
//    }
//
//    /**
//     * 根据表单Code获取详细json配置
//     *
//     * @return
//     */
//    @ApiOperation(value = "根据表单Code获取详细json配置")
//    @GetMapping("/form-settings/codes/{code}")
//    @ResponseBody
//    public ResponseEntity pageBoSettingsByCode(
//            @ApiParam(value = "表单Code") @PathVariable String code,
//            @ApiParam(value = "租户Code") @RequestParam(value = "tenantCode", required = false) String tenantCode) {
//        DataSet ds = null;
//
//        Response<UltForm> response = new Response<>();
//        if (!StringUtils.isEmpty(code)) {
//            ResponseList<UltForm> items = getSettingsByCode(code, tenantCode);
//            if (items.size() >= 1) {
//                response.setMessage("查询成功");
//                response.setCode("200");
//                response.setResult(items.get(0));
//                return ResponseEntity.ok(response);
//            } else {
//                response.setMessage("菜单未部署");
//                response.setCode("400");
//                return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//            }
//        } else {
//            response.setMessage("未传id");
//            response.setCode("400");
//            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
//        }
//    }
//
//    private Response initSettings(String id) {
//        String accessUri = ExternalServiceConfig.PfcpAccessUri();
//        String url = String.format("%s/forms/%s/deployments"
//                , accessUri
//                , id);
//        Authorization auth = new Authorization();
//        auth.setAppId(Long.parseLong(config.getAppId()));
////        auth.setTenantId(Long.parseLong(config.getTenant()));
//        auth.setEnv(config.getEnv());
//        Response<List<UltForm>> result = new Response<List<UltForm>>();
//        try {
////            result = restTemplate.getForObject(url,Response.class);
//            result = restTemplate.postForObject(url, auth, Response.class);
//            if (result.getResult() != null) {
//                List<UltForm> ultForms = result.getResult();
//                for (int i = 0; i < ultForms.size(); i++) {
//                    UltForm saveUltForm = JSON.parseObject(JSON.toJSONString(ultForms.get(i)), UltForm.class);
//                    formBoMapLocalStore.save(saveUltForm);
//                }
//            }
//            return result;
//        } catch (Exception e) {
//            result.setCode("500");
//            result.setMessage("获取失败");
//            return result;
//        }
//    }
//
//    private ResponseList getSettings(String id, String tenantCode) {
//        DataSet ds = null;
//        if (!StringUtils.isEmpty(id)) {
//            List<Row> trows = new ArrayList<>();
//            if (!StringUtils.isEmpty(tenantCode)) {
//                ds = formBoMapLocalStore.query().selectAll()
//                        .where("refFormId")
//                        .eq(id)
//                        .and("tenantCode")
//                        .eq(tenantCode)
//                        .execute();
//                trows = ds.toRows();
//            }
//            if (ds != null && trows != null && trows.size() > 0) {
//                ResponseList<UltForm> items = trows.stream().
//                        map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            } else {
//                ds = formBoMapLocalStore.query().selectAll()
//                        .where("id")
//                        .eq(id)
//                        .execute();
//                List<Row> rows = ds.toRows();
//                ResponseList<UltForm> items = rows.stream().
//                        map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            }
//        } else {
//            return null;
//        }
//    }
//
//    private ResponseList getSettingsByCode(String code, String tenantCode) {
//        DataSet ds = null;
//        if (!StringUtils.isEmpty(code)) {
//            List<Row> trows = new ArrayList<>();
//            if (!StringUtils.isEmpty(tenantCode)) {
//                ds = formBoMapLocalStore.query().selectAll()
//                        .where("code")
//                        .eq(code)
//                        .and("tenantCode")
//                        .eq(tenantCode)
//                        .orderBy("id")
//                        .desc()
//                        .execute();
//                trows = ds.toRows();
//            }
//            if (ds != null && trows != null && trows.size() > 0) {
//                ResponseList<UltForm> items = trows.stream().
//                        map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            } else {
//                ds = formBoMapLocalStore.query().selectAll()
//                        .where("code")
//                        .eq(code)
//                        .and("tenantCode").isNull().or("tenantCode").eq("")
//                        .orderBy("id")
//                        .desc()
//                        .execute();
//                List<Row> rows = ds.toRows();
//                ResponseList<UltForm> items = rows.stream().
//                        map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
//                return items;
//            }
//        } else {
//            return null;
//        }
//    }
//
//    private UltForm toUltForm(Row row) {
//        UltForm ultForm = new UltForm();
//        ultForm.setId(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse("")));
//        ultForm.setName(RowUtils.getRowValue(row, "name").map(Object::toString).orElse(""));
//        ultForm.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
//        ultForm.setRefFormId(Long.parseLong(RowUtils.getRowValue(row, "refFormId").map(Object::toString).orElse("")));
//        if (!"".equals(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))) {
//            ultForm.setTenantId(Long.parseLong(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse("")));
//        }
//
//        if (!"".equals(RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse(""))) {
//            ultForm.setTenantCode(RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse(""));
//        }
//        ultForm.setTenantName(RowUtils.getRowValue(row, "tenantName").map(Object::toString).orElse(""));
//        ultForm.setSetting(RowUtils.getRowValue(row, "setting").map(Object::toString).orElse(""));
//        return ultForm;
//    }
//}
