package com.xforceplus.ultraman.sdk.controller.config;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.controller.interceptor.CodeExtendedInterceptor;
import com.xforceplus.ultraman.sdk.controller.interceptor.ContextInterceptor;
import com.xforceplus.ultraman.sdk.controller.interceptor.DefaultSearchInterceptor;
import com.xforceplus.ultraman.sdk.controller.interceptor.MatchRouter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value = {"xplat.oqsengine.sdk.endpoints.interceptor.enabled", "xplat.oqsengine.sdk.enabled"}, matchIfMissing = true)
public class InterceptorAutoConfiguration {

    @Bean
    public MessageDispatcherInterceptor<?> codeExtendInterceptor(EntityClassEngine engine) {
        return new CodeExtendedInterceptor<>(engine);
    }

    @Bean
    public MessageDispatcherInterceptor<?> contextAwareInterceptor(ContextService contextService) {
        return new ContextInterceptor<>(contextService);
    }

    @ConditionalOnBean(name = "searchCondition", value = {MatchRouter.class})
    @Bean
    public MessageDispatcherInterceptor<?> DefaultSearchInterceptor(MatchRouter<String, ConditionQueryRequest> matchRouter) {
        return new DefaultSearchInterceptor<>(matchRouter);
    }
}
