package com.xforceplus.ultraman.sdk.controller.interceptor;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import org.springframework.core.Ordered;

import java.util.List;
import java.util.function.BiFunction;

/**
 * move context service value into QueryMessage metadata
 * @param <T>
 * @param <R>
 */
public class ContextInterceptor<T, R> implements MessageDispatcherInterceptor<QueryMessage<T, R>> {

    private ContextService contextService;

    public ContextInterceptor(ContextService contextService){
        this.contextService = contextService;
    }

    @Override
    public BiFunction<Integer, QueryMessage<T, R>, QueryMessage<T, R>> handle(List<? extends QueryMessage<T, R>> list) {
        return (index, queryMessage) -> {
            if (contextService != null) {
                return (QueryMessage<T, R>) queryMessage
                        .withMetaData(queryMessage.getMetaData()
                                .mergedWith(contextService.getAll()));
            } else {
                return queryMessage;
            }
        };
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}

