package com.xforceplus.ultraman.sdk.controller;


import com.google.common.collect.Sets;
import com.xforceplus.ultraman.extensions.business.EntityInstance;
import com.xforceplus.ultraman.extensions.business.service.BusinessFacade;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.controller.dto.KeyConditionsContainer;
import com.xforceplus.ultraman.sdk.controller.dto.KeyResult;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpQuery;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRange;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

@RequestMapping
@Api(value = "/", tags = "entities")
public class ExtraController {

    @Autowired
    private BusinessFacade businessFacade;

    private int limit = 1000;

    public ExtraController(int limit) {
        this.limit = limit;
    }

    @PostMapping("/extra/{boId}/entities/nonExists")
    @ResponseBody
    public Response<KeyResult> nonExists(@ApiParam(value = "元数据对象ID") @PathVariable String boId,
                                         @RequestBody KeyConditionsContainer keyConditionList) {
        IEntityClass metaData = businessFacade.load(Long.parseLong(boId));
        ExpRel expRel = toExpRel(keyConditionList);
        if(expRel instanceof ExpQuery) {
            ((ExpQuery) expRel).setRange(new ExpRange(1, 10000));
        }
        DataCollection<EntityInstance> byCondition = businessFacade.findByCondition(metaData, expRel);
        List<String> keys = queryKeys(keyConditionList);
        Set<String> valueMapping = valueSet(keyConditionList, keys);
        Set<String> collect = byCondition.getRows().stream().map(x -> {
            StringBuilder sb = new StringBuilder();
            keys.forEach(k -> {
                Optional<Object> value = x.getValue(k);
                value.ifPresent(sb::append);
                sb.append("%%");
            });
            return sb.toString();
        }).collect(Collectors.toSet());

        Sets.SetView<String> differenceView = Sets.difference(valueMapping, collect);
        List<Map<String, String>> resultMapping = differenceView.stream().map(x -> {
            String[] split = x.split("%%");
            Map<String, String> mapping = new HashMap<>();
            int i = 0;
            for (String key : keys) {
                mapping.put(key, split[i++]);
            }
            return mapping;
        }).collect(Collectors.toList());

        KeyResult keyResult = new KeyResult();
        keyResult.setRows(resultMapping);
        Response<KeyResult> result = Response.from("1", "没有查询到的请求", keyResult);
        return result;
    }

    private Set<String> valueSet(KeyConditionsContainer keys, List<String> keySet) {
        List<Map<String, Object>> conditions = keys.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return Collections.emptySet();
        }

        List<String> valueStr = new ArrayList<>();

        Set<String> hashMapping = keys.getConditions().stream().map(x -> {
            StringBuilder sb = new StringBuilder();
            keySet.forEach(k -> {
                Object o = x.get(k);
                sb.append(o == null ? "" : o.toString());
                sb.append("%%");
            });
            return sb.toString();
        }).collect(Collectors.toSet());

        return hashMapping;
    }

    private List<String> queryKeys(KeyConditionsContainer keys) {
        List<Map<String, Object>> conditions = keys.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return Collections.emptyList();
        }

        Map<String, Object> map = conditions.get(0);
        return new ArrayList<>(map.keySet());
    }

    private ExpRel toExpRel(KeyConditionsContainer keyConditionList) {
        List<Map<String, Object>> conditions = keyConditionList.getConditions();

        if (conditions == null) {
            throw new RuntimeException("conditions is null");
        }

        if (conditions.size() > limit) {
            throw new RuntimeException("overflow the condition size request size " + conditions.size() + ", limit" + limit);
        }

        Optional<ExpRel> reduce = conditions.stream().map(x -> {
            ExpQuery from = ExpFactory.createFrom(x);
            return (ExpRel) from;
        }).reduce((k, v) -> {
            return k.mergeOr(v);
        });

        return reduce.orElseThrow(() -> new RuntimeException("condition not found"));
    }
}
