package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.ultraman.config.storage.ConfigurationStorage;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLSchemaHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Map;

/**
 * config current controller
 */
@Api(value = "/", tags = "元数据配置历史")
@RequestMapping
public class ConfigController {

    @Autowired(required = false)
    private ConfigurationStorage configurationStorage;

    @Autowired
    private GraphQLSchemaHolder holder;

    @ApiOperation(
            value = "查询元数据更新的历史"
            , notes = "元数据更新历史")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "Map", response = Map.class)
    })
    @GetMapping("/history")
    @ResponseBody
    public Response refresh(){
        holder.clearAll();
        return Response.ok("ok");
    }


    @ApiOperation(
            value = "查询元数据更新的历史"
            , notes = "元数据更新历史")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "Map", response = Map.class)
    })
    @GetMapping("/history")
    @ResponseBody
    public Map getHistory(){
        return configurationStorage.getCurrentState().getHistoryRecords();
    }

    @ApiOperation(
            value = "查询元数据变更历史"
            , notes = "元数据变更历史，主要包括如何从A配置 -> B配置的变化")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "Map", response = Map.class)
    })
    @GetMapping("/changelist")
    @ResponseBody
    public Map getChangelist(){
        return configurationStorage.getCurrentState().getCurrentChangeList();
    }
}
