package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.ultraman.metadata.domain.vo.dto.*;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import com.xforceplus.ultraman.metadata.entity.impl.LazyField;
import com.xforceplus.ultraman.sdk.infra.event.EventEngine;
import com.xforceplus.ultraman.sdk.infra.event.UltramanLifecycle;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Api(value = "/", tags = "元数据对象操作")
@RequestMapping
public class ModuleController {

    @Autowired(required = false)
    private ProfileFetcher profileFetcher;

    @Autowired
    private EntityClassEngine engine;
    
    @Autowired
    private MetadataEngine metadataEngine;
    
    @Autowired
    private EventEngine eventEngine;

    private String appId;

    private String tenantId;

    public ModuleController(String appId, String tenantId) {
        this.appId = appId;
        this.tenantId = tenantId;
    }


    @PostMapping("/cache/refresh")
    @ResponseBody
    public Response<String> refreshCache() {
        eventEngine.refresh(UltramanLifecycle.METADATA_REFRESHED);
        return Response.ok("ok");
    }
    
    @ApiOperation(value = "获取当前元数据对象的子对象")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "包含元数据对象的Response", response = Response.class)
    })
    @GetMapping("/bos/entityClass/domain/{code}")
    @ResponseBody
    public Response<BoInfoVo> getSonBoInfoList(@PathVariable("code") String code) {

        String profile = profileFetcher.getProfile(Collections.emptyMap());
        Optional<IEntityClass> entityClassOp = engine.loadByCode(code, profile);

        if(entityClassOp.isPresent()) {
            IEntityClass entityClass = entityClassOp.get();
            BoInfoVo boInfoVo = new BoInfoVo();
            boInfoVo.setId(entityClass.id());
            boInfoVo.setCode(entityClass.code());
            boInfoVo.setBoType(Integer.toString(entityClass.getType()));
            boInfoVo.setFields(entityClass.fields().stream().map(x -> toBoField(x, boInfoVo.getId())).collect(Collectors.toList()));
            boInfoVo.setParentBoId(entityClass.extendEntityClass() == null ? null : entityClass.extendEntityClass().id());
            boInfoVo.setName(entityClass.name());
            boInfoVo.setProfile(profile);
            boInfoVo.setApis(engine.loadApiByCode(code, profile));

            Response<BoInfoVo> response = new Response<>();
            response.setCode("1");
            response.setMessage("获取成功");
            response.setResult(boInfoVo);
            return response;
        } else {
            return Response.Error("No Related EntityClass");
        }
    }
    
    private BoItem toBoItem(EntityClassGroup group) {
        BoItem boItem = new BoItem();
        //remove all api
        boItem.setApi(Collections.emptyMap());
        
        boItem.setParentEntityId(group.getFatherEntityClass().stream().findFirst()
                .map(x -> Long.toString(x.id())).orElse(null));
        //TODO
        boItem.setSubEntities(group.getChildrenEntityClass().stream()
                .map(x -> Long.toString(x.id())).collect(Collectors.toList()));
        boItem.setFields(group.getEntityClass().fields()
                .stream().map(this::toFieldItem)
                .collect(Collectors.toList()));
        return boItem;
    }
    
    private FieldItem toFieldItem(IEntityField field) {
        FieldItem fieldItem = new FieldItem();
        fieldItem.setCode(field.name());
        fieldItem.setName(field.cnName());
        fieldItem.setType(field.type().name());
        fieldItem.setEditable(field.config().isEditable()? "true": "false");
        fieldItem.setRequired(field.config().isRequired()? "true" : "false");
        fieldItem.setDefaultValue(Optional.ofNullable(field.defaultValue()).orElse(""));
        fieldItem.setDictId(field.dictId());
        fieldItem.setMaxLength(Long.toString(field.config().getLen()));
        fieldItem.setSearchable(field.config().isSearchable() ? "true": "false");
        /**
         *     "enumCode": null,
         *         "displayType": null,
         *         "precision": null,
         *         "dictId": null,
         *         "defaultValue": null,
         *         "relationshipEntity": null,
         *         "uniqueName": null
         */
        fieldItem.setEnumCode("");
        fieldItem.setDisplayType("0");
        fieldItem.setPrecision("0");
        fieldItem.setUniqueName("");
        return fieldItem;
    }
    
    @ApiOperation(
            value = "获取元数据对象详细信息"
            , notes = "如果结果存在返回Response<BoItem>对象，如果没有则抛出异常")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "code == 1 返回值为 1", response = Response.class),
            @ApiResponse(code = 500, message = "任意错误, code == -1, 数据不存在或者对象不存在都会报错", response = Response.class)}
    )
    //TODO tenantId and appCode not used currently
    @GetMapping("/bos/{id}/entityClass")
    @ResponseBody
    public Response<BoItem> getBoDetails(
            @ApiParam(value = "元数据对象Id") @PathVariable String id
    ) {

        String profile =  profileFetcher.getProfile(Collections.emptyMap());
        Response<BoItem> response = new Response<>();
        Optional<IEntityClass> load = engine.load(id, profile);
        BoItem boItem = null;
        if(load.isPresent()) {
            IEntityClass entityClass = load.get();
            EntityClassGroup group = engine.describe(entityClass, profile);
            boItem = toBoItem(group);
        }
        
        if (boItem != null) {
            //TODO ? any failure condition
            response.setCode("1");
            response.setMessage("获取成功");
            response.setResult(boItem);

        } else {
            response.setCode("-1");
            response.setMessage("不存在该对象");
        }
        return response;
    }

    private BoFieldVo toBoField(IEntityField entityField, long boId) {
        BoFieldVo fieldVo = new BoFieldVo();
        fieldVo.setCode(entityField.name());
        fieldVo.setBoId(boId);
        fieldVo.setName(entityField.cnName());
        fieldVo.setType(entityField.type().name());
        return fieldVo;
    }
}