package com.xforceplus.ultraman.sdk.controller.config;

import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.sdk.controller.*;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value = {"xplat.oqsengine.sdk.endpoints.enabled", "xplat.oqsengine.sdk.enabled"}, matchIfMissing = true)
public class RestControllerAutoConfiguration {

    /**
     * default entitycontroller
     * @return
     */
    @Bean
    public EntityController entityController(){
        return new EntityController();
    }

    /**
     * default dict controller
     * @param dictService
     * @return
     */
    @Bean
    public DictController dictController(DictService dictService){
        return new DictController(dictService);
    }

    @Bean
    public SystemController systemController() {
        return new SystemController();
    }

    @Bean
    public DevopsController devopsController() {
        return new DevopsController();
    }

    @Bean
    public ExtraController extraController(ExecutionConfig executionConfig) {
        return new ExtraController(executionConfig.getExtraSize());
    }

    @Bean
    public ModuleController moduleController(AuthConfig authConfig) {
        return new ModuleController(authConfig.getAppId(), authConfig.getTenant());
    }
}
