package com.xforceplus.ultraman.sdk.controller.interceptor;

import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.cmd.MetaDataLikeCmd;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

/**
 * TODO
 * interceptor for code and parentCode
 *
 * @param <T>
 * @param <R>
 * @author admin
 */
public class CodeExtendedInterceptor<T, R> implements MessageDispatcherInterceptor<QueryMessage<T, R>> {

    private final EntityClassEngine engine;

    public CodeExtendedInterceptor(EntityClassEngine engine) {
        this.engine = engine;
    }

    @SuppressWarnings("unchecked")
    @Override
    public BiFunction<Integer, QueryMessage<T, R>, QueryMessage<T, R>> handle(List<? extends QueryMessage<T, R>> list) {
        return (index, queryMessage) -> {
            if (MetaDataLikeCmd.class.isAssignableFrom(queryMessage.getPayloadType())) {

                Optional<IEntityClass> boItem = engine.load(((MetaDataLikeCmd) queryMessage.getPayload()).getBoId(), "");
                if (boItem.isPresent()) {
                    IEntityClass ptr = boItem.get();
                    List<String> codes = new ArrayList<>(5);
                    EntityClassGroup group = engine.describe(ptr, "");
                    group.getFatherEntityClass().forEach(f -> {
                        codes.add(f.code());
                    });
                    codes.add(ptr.code());

                    //TODO
                    return (QueryMessage) queryMessage
                            .withMetaData(queryMessage.getMetaData()
                                    .and("code", ptr.code())
                                    .and("parentCode", codes.isEmpty() ? "" : codes.get(0))
                                    .and("name", ptr.name())
                                    .and("codes", codes));

                } else {
                    return (QueryMessage) queryMessage.withMetaData(queryMessage.getMetaData().and("code", ""));
                }
            }
            return queryMessage;
        };
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
