package com.xforceplus.ultraman.sdk.controller.interceptor;

import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import com.xforceplus.ultraman.sdk.core.cmd.MetaDataLikeCmd;

import java.util.List;
import java.util.function.BiFunction;

/**
 * disable version
 * @param <R>
 * @param <T>
 */
public class VersionInterceptor<T, R> implements MessageDispatcherInterceptor<QueryMessage<T, R>> {

    @Override
    public BiFunction<Integer, QueryMessage<T, R>, QueryMessage<T, R>> handle(List<? extends QueryMessage<T, R>> list) {
        return (index, queryMessage) -> {
            if (MetaDataLikeCmd.class.isAssignableFrom(queryMessage.getPayloadType())) {
                ((MetaDataLikeCmd) queryMessage.getPayload()).clearVersion();
            }
            return queryMessage;
        };
    }
}
