package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.devops.DevOpsService;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DevOpsTaskInfo;
import com.xforceplus.ultraman.sdk.controller.devops.RebuildIndexes;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * Created by justin.xu on 08/2023.
 *
 * @since 1.8
 */
@Api(value = "/", tags = "运维接口")
@RequestMapping(value = {"/", "api/dev/"})
public class DevopsController {

    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    @Autowired
    private EntityClassEngine engine;
    @Autowired
    private DevOpsService devOpsService;

    /**
     * 批量重建索引.
     */
    @PostMapping(value = "/rebuild-indexes", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Collection<DevOpsTaskInfo>> rebuildIndexes(@RequestBody RebuildIndexes rebuildIndexes) {

        List<IEntityClass> entityClasses = null;
        if (null != rebuildIndexes.getAppCode() && !rebuildIndexes.getAppCode().isEmpty()) {
            entityClasses = engine.findAllEntities(rebuildIndexes.getProfile());
        } else {
            entityClasses = engine.findAllEntities(rebuildIndexes.getProfile()).stream().filter(
                    e -> {
                        return rebuildIndexes.getEntityClassIds().contains(Long.toString(e.id()));
                    }
            ).collect(Collectors.toList());
        }

        if (null == entityClasses || entityClasses.isEmpty()) {
            return ResponseEntity.ok(null);
        }

        return ResponseEntity.ok(
                devOpsService.rebuildIndexes(entityClasses,
                        LocalDateTime.parse(rebuildIndexes.getStart(), dateTimeFormatter),
                        LocalDateTime.parse(rebuildIndexes.getEnd(), dateTimeFormatter)));
    }

    /**
     * 取消任务.
     */
    @PutMapping(value = "/cancel-rebuild-index/", consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Boolean> cancelTask(@RequestBody List<Long> ids) throws Exception {

        int canceledSize = 0;
        for (Long id : ids) {
            if (devOpsService.cancel(id)) {
                canceledSize++;
            }
        }

        return ResponseEntity.ok(canceledSize == ids.size());
    }

    /**
     * 获取当前的(活动)任务列表.
     */
    @GetMapping(value = "/list-rebuild-indexes/", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<Collection<DevOpsTaskInfo>> queryTasks(@RequestParam("batchId") long batchId) throws SQLException {
        return ResponseEntity.ok(devOpsService.listTasks(batchId));
    }

    /**
     * 获取当前的(活动)任务列表.
     */
    @GetMapping(value = "/query-rebuild-index", produces = MediaType.APPLICATION_JSON_VALUE)
    ResponseEntity<DevOpsTaskInfo> queryTask(@RequestParam("maintainId") long maintainId) throws SQLException {
        Optional<DevOpsTaskInfo> devOpsTaskInfo = devOpsService.listTask(maintainId);
        return ResponseEntity.ok(devOpsTaskInfo.orElse(null));
    }
}
