package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.domain.vo.dto.DictItem;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ResponseList;
import com.xforceplus.ultraman.metadata.service.DictService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.xforceplus.tech.base.core.context.ContextKeys.StringKeys.TENANTCODE_KEY;


/**
 * @author admin
 */
@Api(value = "/", tags = "字典操作")
@RequestMapping(value = {"/", "api/0/${xplat.oqsengine.sdk.auth.appcode:dummy}"})
public class DictController {

    private DictService dictService;

    @Autowired
    private ContextService contextService;

    public DictController(DictService dictService) {
        this.dictService = dictService;
    }

    @ApiOperation(value = "根据Id查询字典选项", notes = "会根据上下文中的租户code获取不同的内容")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "字典列表", response = DictItem.class, responseContainer = "List")
    })
    @GetMapping("/enum/{id}/options")
    @ResponseBody
    public ResponseEntity getDict(
            @ApiParam(value = "枚举id") @PathVariable("id") String enumId
          , @ApiParam(value = "枚举code") @RequestParam(required = false) String enumCode
    ) {
        String tenantCode = contextService.get(TENANTCODE_KEY);
        Response<ResponseList<DictItem>> response = new Response<>();
        List<DictItem> dictItems = dictService.findDictItems(enumId, enumCode, tenantCode);

        if (dictItems.size() > 0) {
            response.setMessage("查询成功");
            response.setCode("200");
            response.setResult((ResponseList<DictItem>) dictItems);
            return ResponseEntity.ok(response);
        } else {
            response.setMessage("查询无结果");
            response.setCode("400");
            return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
        }
    }

    @ApiOperation(value = "根据字典多个id获取字典", notes = "会根据上下文中的租户code获取不同的内容")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "字典列表", response = DictItem.class, responseContainer = "List")
    })
    @GetMapping("/enums/options")
    @ResponseBody
    public ResponseEntity getDicts(
            @ApiParam(value = "枚举ids") @RequestParam(required = false, value = "ids") String[] enumIds
    ) {
        String tenantCode = contextService.get(TENANTCODE_KEY);
        Response<Map<String, List<DictItem>>> response = new Response<>();
        if (enumIds != null && enumIds.length > 0) {
            Map<String, List<DictItem>> enums = new HashMap<>();
            for (String enumId : enumIds) {
                List<DictItem> dictItems = dictService.findDictItems(enumId, null, tenantCode);
                enums.put(enumId, dictItems);
            }
            if (enums.size() > 0) {
                response.setMessage("查询成功");
                response.setCode("1");
                response.setResult(enums);
                return ResponseEntity.ok(response);
            } else {
                response.setMessage("查询无结果");
                response.setCode("-1");
                return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(response);
            }
        } else {
            List<DictItem> dictItems = dictService.findAllDictItems(tenantCode);
            response.setResult(dictItems.stream().collect(Collectors.groupingBy(DictItem::getDictId)));
            response.setMessage("查询成功");
            response.setCode("1");
            return ResponseEntity.ok(response);
        }
    }
}
