package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.metadata.schema.typed.BoField;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoFieldVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.BoInfoVo;
import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Api(value = "/", tags = "元数据对象操作")
@RequestMapping
public class ModuleController {

    @Autowired(required = false)
    private ProfileFetcher profileFetcher;

    @Autowired
    private EntityClassEngine engine;

    private String appId;

    private String tenantId;

    public ModuleController(String appId, String tenantId) {
        this.appId = appId;
        this.tenantId = tenantId;
    }

    @ApiOperation(value = "获取当前元数据对象的子对象")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "包含元数据对象的Response", response = Response.class)
    })
    @GetMapping("/bos/entityClass/domain/{code}")
    @ResponseBody
    public Response<BoInfoVo> getSonBoInfoList(@PathVariable("code") String code) {

        String profile = profileFetcher.getProfile(Collections.emptyMap());
        Optional<IEntityClass> entityClassOp = engine.loadByCode(code, profile);

        if(entityClassOp.isPresent()) {
            IEntityClass entityClass = entityClassOp.get();
            BoInfoVo boInfoVo = new BoInfoVo();
            boInfoVo.setId(entityClass.id());
            boInfoVo.setCode(entityClass.code());
            boInfoVo.setBoType(Integer.toString(entityClass.getType()));
            boInfoVo.setFields(entityClass.fields().stream().map(x -> toBoField(x, boInfoVo.getId())).collect(Collectors.toList()));
            boInfoVo.setParentBoId(entityClass.extendEntityClass() == null ? null : entityClass.extendEntityClass().id());
            boInfoVo.setName(entityClass.name());
            boInfoVo.setProfile(profile);
            boInfoVo.setApis(engine.loadApiByCode(code, profile));

            Response<BoInfoVo> response = new Response<>();
            response.setCode("1");
            response.setMessage("获取成功");
            response.setResult(boInfoVo);
            return response;
        } else {
            return Response.Error("No Related EntityClass");
        }
    }

    private BoFieldVo toBoField(IEntityField entityField, long boId) {
        BoFieldVo fieldVo = new BoFieldVo();
        fieldVo.setCode(entityField.name());
        fieldVo.setBoId(boId);
        fieldVo.setName(entityField.cnName());
        fieldVo.setType(entityField.type().name());
        return fieldVo;
    }
}