package com.xforceplus.ultraman.sdk.controller;

import com.xforceplus.ultraman.metadata.domain.vo.dto.Response;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.sdk.graphql.config.GraphQLSchemaHolder;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping("/system")
@Api(value = "/system", tags = "系统操作")
public class SystemController {

    @Autowired
    private GraphQLSchemaHolder holder;

    @Autowired
    private EntityClassEngine engine;


    @GetMapping("/refresh")
    @ResponseBody
    public Response refresh(){
        holder.clearAll();
        engine.onRefresh(null);
        return Response.ok("ok");
    }
}
