package com.xforceplus.ultraman.sdk.controller.config;

import com.xforceplus.ultraman.metadata.service.DictService;
import com.xforceplus.ultraman.sdk.controller.DictController;
import com.xforceplus.ultraman.sdk.controller.EntityController;
import com.xforceplus.ultraman.sdk.controller.ModuleController;
import com.xforceplus.ultraman.sdk.controller.SystemController;
import com.xforceplus.ultraman.sdk.infra.base.AuthConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(value = {"xplat.oqsengine.sdk.endpoints.enabled", "xplat.oqsengine.sdk.enabled"}, matchIfMissing = true)
public class RestControllerAutoConfiguration {

    /**
     * default entitycontroller
     * @return
     */
    @Bean
    public EntityController entityController(){
        return new EntityController();
    }

    /**
     * default dict controller
     * @param dictService
     * @return
     */
    @Bean
    public DictController dictController(DictService dictService){
        return new DictController(dictService);
    }

    @Bean
    public SystemController systemController() {
        return new SystemController();
    }

    @Bean
    public ModuleController moduleController(AuthConfig authConfig) {
        return new ModuleController(authConfig.getAppId(), authConfig.getTenant());
    }
}
