/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.devops.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.dto.BatchStatus;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DevOpsTaskInfo;

public class DefaultDevOpsTaskInfo
implements DevOpsTaskInfo {
    public static final int UN_DONE_BATCH_SIZE = 0;
    private boolean useCDC;
    private long maintainid;
    private long batchId;
    private long entity;
    private long starts;
    private long ends;
    private volatile long batchSize;
    private volatile int finishSize;
    private volatile int errorSize;
    private volatile int status;
    private long createTime;
    private long updateTime;
    private String message = "";
    private long startId;
    private int autoRetryTime;
    private String profile = "";
    @JsonIgnore
    private IEntityClass entityClass;

    public DefaultDevOpsTaskInfo() {
    }

    public DefaultDevOpsTaskInfo(long batchId, long maintainid) {
        this.batchId = batchId;
        this.maintainid = maintainid;
    }

    public DefaultDevOpsTaskInfo(long batchId, long maintainId, IEntityClass entityClass, long starts, long ends) {
        this(batchId, maintainId, entityClass.id(), starts, ends, 0, 0, BatchStatus.RUNNING.getCode(), System.currentTimeMillis(), 0L);
        this.entityClass = entityClass;
        this.message = "TASK RUNNING";
    }

    public DefaultDevOpsTaskInfo(long batchId, long maintainId, long entity, long starts, long ends, int batchSize, int finishSize, int status, long createTime, long updateTime) {
        this.batchId = batchId;
        this.maintainid = maintainId;
        this.entity = entity;
        this.starts = starts;
        this.ends = ends;
        this.batchSize = batchSize;
        this.finishSize = finishSize;
        this.status = status;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    @Override
    public long updateTime() {
        return this.updateTime;
    }

    @Override
    public long getMaintainid() {
        return this.maintainid;
    }

    @Override
    public long getEntity() {
        return this.entity;
    }

    @Override
    public long getStarts() {
        return this.starts;
    }

    @Override
    public long getEnds() {
        return this.ends;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public IEntityClass getEntityClass() {
        return this.entityClass;
    }

    public long getBatchId() {
        return this.batchId;
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getFinishSize() {
        return this.finishSize;
    }

    @Override
    public int getErrorSize() {
        return this.errorSize;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public void resetMessage(String message) {
        if (null != message) {
            this.message = message.length() > 500 ? message.substring(0, 500) : message;
        }
    }

    @Override
    public void resetStatus(int status) {
        this.status = status;
    }

    @Override
    public void setFinishSize(int finishSize) {
        this.finishSize = finishSize;
    }

    @Override
    public void addFinishSize(int addSize) {
        this.finishSize += addSize;
    }

    @Override
    public void addBatchSize(int addBatchSize) {
        this.batchSize += (long)addBatchSize;
    }

    @Override
    public void setErrorSize(int size) {
        this.errorSize = Long.valueOf(size).intValue();
    }

    @Override
    public void resetUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean useCDC() {
        return this.useCDC;
    }

    @Override
    public String id() {
        return Long.toString(this.maintainid);
    }

    @Override
    public boolean isDone() {
        return this.status == BatchStatus.DONE.getCode();
    }

    @Override
    public boolean isError() {
        return this.status == BatchStatus.ERROR.getCode();
    }

    @Override
    public boolean isCancel() {
        return this.status == BatchStatus.CANCEL.getCode();
    }

    @Override
    public BatchStatus status() {
        return BatchStatus.toBatchStatus((int)this.status);
    }

    @Override
    public boolean isEnd() {
        return this.isDone() || this.isError() || this.isCancel();
    }

    @Override
    public long getProgressPercentage() {
        return 0L < this.batchSize ? (long)this.finishSize * 100L / this.batchSize : 0L;
    }

    @Override
    public void setBatchSize(long size) {
        this.batchSize = size;
    }

    @Override
    public long getStartId() {
        return this.startId;
    }

    @Override
    public void setStartId(long startId) {
        this.startId = startId;
    }

    @Override
    public long batchId() {
        return this.batchId;
    }

    @Override
    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public boolean isUseCDC() {
        return this.useCDC;
    }

    public void setUseCDC(boolean useCDC) {
        this.useCDC = useCDC;
    }

    @Override
    public int getAutoRetryTime() {
        return this.autoRetryTime;
    }

    @Override
    public void setAutoRetryTime(int autoRetryTime) {
        this.autoRetryTime = autoRetryTime;
    }

    @Override
    public void incAutoRetryTime() {
        ++this.autoRetryTime;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
    }
}

