/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.devops;

import com.xforceplus.ultraman.cdc.adapter.EngineAdapterService;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.common.iterator.DataIterator;
import com.xforceplus.ultraman.oqsengine.plus.devops.DevOpsService;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.BatchStatus;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DefaultDevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.devops.storage.SQLTaskStorage;
import com.xforceplus.ultraman.oqsengine.plus.master.mysql.MasterStorage;
import com.xforceplus.ultraman.sdk.infra.base.id.LongIdGenerator;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildDevOpsService
implements DevOpsService {
    final Logger logger = LoggerFactory.getLogger(RebuildDevOpsService.class);
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private EntityClassEngine engine;
    @Resource
    private EngineAdapterService engineAdapterService;
    @Resource
    private SQLTaskStorage sqlTaskStorage;
    @Resource(name="longNoContinuousPartialOrderIdGenerator")
    private LongIdGenerator idGenerator;
    private ZoneOffset zoneOffset = OffsetDateTime.now().getOffset();
    @Resource(name="rebuildThreadPool")
    private ExecutorService asyncThreadPool;
    private static final int BATCH_QUERY_SIZE = 2048;
    private int querySize = 2048;
    private int taskSize;

    public RebuildDevOpsService(int taskSize, int querySize) {
        this.taskSize = taskSize;
        if (querySize > 0) {
            this.querySize = querySize;
        }
    }

    @Override
    public DevOpsTaskInfo rebuildIndex(IEntityClass entityClass, LocalDateTime start, LocalDateTime end) {
        DefaultDevOpsTaskInfo devOpsTaskInfo = this.pending((Long)this.idGenerator.next(), entityClass, start, end);
        this.logger.info("pending rebuildIndex task, maintainId {}, entityClass {}, start {}, end {}", new Object[]{devOpsTaskInfo.id(), entityClass.id(), start, end});
        if (0 == this.sqlTaskStorage.build(devOpsTaskInfo)) {
            return null;
        }
        this.asyncThreadPool.submit(() -> this.handleTask(devOpsTaskInfo));
        return devOpsTaskInfo;
    }

    @Override
    public Collection<DevOpsTaskInfo> rebuildIndexes(Collection<IEntityClass> entityClasses, LocalDateTime start, LocalDateTime end) {
        ArrayList<DevOpsTaskInfo> devOps = new ArrayList<DevOpsTaskInfo>();
        long batchId = (Long)this.idGenerator.next();
        for (IEntityClass entityClass : entityClasses) {
            DefaultDevOpsTaskInfo devOpsTaskInfo = this.pending(batchId, entityClass, start, end);
            this.logger.info("pending rebuildIndex task, maintainId {}, entityClass {}, start {}, end {}", new Object[]{devOpsTaskInfo.id(), entityClass.id(), start, end});
            try {
                if (0 == this.sqlTaskStorage.build(devOpsTaskInfo)) {
                    devOpsTaskInfo.resetMessage("init task failed...");
                    devOpsTaskInfo.resetStatus(BatchStatus.ERROR.getCode());
                }
            }
            catch (Exception e) {
                devOpsTaskInfo.resetMessage("init task failed...");
                devOpsTaskInfo.resetStatus(BatchStatus.ERROR.getCode());
            }
            devOps.add(devOpsTaskInfo);
        }
        for (DevOpsTaskInfo devOpsTaskInfo : devOps) {
            this.asyncThreadPool.submit(() -> this.handleTask(devOpsTaskInfo));
        }
        return devOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(DevOpsTaskInfo devOpsTaskInfo) {
        DataIterator iterator = null;
        try {
            if (devOpsTaskInfo.getStatus() == BatchStatus.ERROR.getCode()) {
                this.sqlTaskStorage.error(devOpsTaskInfo);
                return;
            }
            int updateFlag = 0;
            int frequency = 10;
            iterator = this.masterStorage.iterator(devOpsTaskInfo.getEntityClass(), devOpsTaskInfo.getStarts(), devOpsTaskInfo.getEnds(), devOpsTaskInfo.getStartId(), this.querySize, true);
            ArrayList<OqsEngineEntity> entities = new ArrayList<OqsEngineEntity>();
            boolean isCanceled = false;
            while (iterator.hasNext()) {
                OqsEngineEntity originalEntity = (OqsEngineEntity)iterator.next();
                originalEntity.setMaintainId(devOpsTaskInfo.getMaintainid());
                entities.add(originalEntity);
                if (entities.size() != this.querySize) continue;
                this.engineAdapterService.batchUpsertOperation(entities);
                devOpsTaskInfo.addBatchSize(entities.size());
                devOpsTaskInfo.addFinishSize(entities.size());
                devOpsTaskInfo.setStartId(originalEntity.getId());
                entities.clear();
                if (++updateFlag != frequency) continue;
                if (0 == this.sqlTaskStorage.update(devOpsTaskInfo)) {
                    isCanceled = true;
                    break;
                }
                updateFlag = 0;
            }
            if (!isCanceled) {
                if (!entities.isEmpty()) {
                    this.engineAdapterService.batchUpsertOperation(entities);
                    devOpsTaskInfo.addBatchSize(entities.size());
                    devOpsTaskInfo.addFinishSize(entities.size());
                }
                devOpsTaskInfo.setStartId(0L);
                this.done(devOpsTaskInfo);
            }
        }
        catch (Exception e) {
            devOpsTaskInfo.resetMessage(e.getMessage());
            try {
                this.sqlTaskStorage.error(devOpsTaskInfo);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            if (iterator != null) {
                try {
                    iterator.destroy();
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean cancel(long maintainId) throws Exception {
        return this.sqlTaskStorage.cancel(maintainId) > 0;
    }

    @Override
    public Optional<DevOpsTaskInfo> listTask(Long maintainId) throws SQLException {
        return this.sqlTaskStorage.selectUnique(maintainId);
    }

    @Override
    public Collection<DevOpsTaskInfo> listTasks(long batchId) throws SQLException {
        return this.sqlTaskStorage.selectActive(batchId);
    }

    private boolean done(DevOpsTaskInfo devOpsTaskInfo) throws SQLException {
        devOpsTaskInfo.resetMessage("success");
        if (this.sqlTaskStorage.done(devOpsTaskInfo) > 0) {
            this.logger.info("task done, maintainId {}, finish batchSize {}", (Object)devOpsTaskInfo.getMaintainid(), (Object)devOpsTaskInfo.getFinishSize());
            ((DefaultDevOpsTaskInfo)devOpsTaskInfo).setStatus(BatchStatus.DONE.getCode());
        } else {
            this.logger.warn("task done error, task update finish status error, maintainId {}", (Object)devOpsTaskInfo.getMaintainid());
        }
        return true;
    }

    private DefaultDevOpsTaskInfo pending(long batchId, IEntityClass entityClass, LocalDateTime start, LocalDateTime end) {
        return new DefaultDevOpsTaskInfo(batchId, (Long)this.idGenerator.next(), entityClass, start.toInstant(this.zoneOffset).toEpochMilli(), end.toInstant(this.zoneOffset).toEpochMilli());
    }
}

