/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.plus.devops.storage;

import com.xforceplus.ultraman.oqsengine.plus.devops.dto.BatchStatus;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DefaultDevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.devops.dto.DevOpsTaskInfo;
import com.xforceplus.ultraman.oqsengine.plus.devops.storage.TaskStorage;
import com.xforceplus.ultraman.oqsengine.plus.devops.storage.TaskStorageCommand;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTaskStorage
implements TaskStorage {
    final Logger logger = LoggerFactory.getLogger(SQLTaskStorage.class);
    @Resource(name="devOpsDataSource")
    private DataSource devOpsDataSource;
    private String table = "devops";

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Integer build(DevOpsTaskInfo taskInfo) {
        try {
            Collection<DevOpsTaskInfo> collection = this.selectActive(taskInfo.getEntity());
            if (0 != collection.size()) {
                for (DevOpsTaskInfo devOpsTaskInfo : collection) {
                    this.cancel(devOpsTaskInfo.getMaintainid());
                }
            }
            return new TaskStorageCommand(this.table).build(this.devOpsDataSource, taskInfo);
        }
        catch (Exception e) {
            this.logger.warn("init rebuild task failed, batchId : {}, taskId : {}, message : {}", new Object[]{taskInfo, taskInfo.id(), e.getMessage()});
            return 0;
        }
    }

    @Override
    public int update(DevOpsTaskInfo taskInfo) throws SQLException {
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int done(DevOpsTaskInfo taskInfo) throws SQLException {
        taskInfo.resetStatus(BatchStatus.DONE.getCode());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int error(DevOpsTaskInfo taskInfo) throws SQLException {
        taskInfo.resetStatus(BatchStatus.ERROR.getCode());
        return new TaskStorageCommand(this.table).update(this.devOpsDataSource, (DefaultDevOpsTaskInfo)taskInfo);
    }

    @Override
    public int cancel(long taskId) throws SQLException {
        return new TaskStorageCommand(this.table).status(this.devOpsDataSource, taskId, BatchStatus.CANCEL, "task canceled");
    }

    @Override
    public Collection<DevOpsTaskInfo> selectActive(long entityClassId) throws SQLException {
        return new TaskStorageCommand(this.table).selectActive(this.devOpsDataSource, entityClassId);
    }

    @Override
    public Optional<DevOpsTaskInfo> selectUnique(long taskId) throws SQLException {
        return new TaskStorageCommand(this.table).selectByUnique(this.devOpsDataSource, taskId);
    }

    @Override
    public Collection<DevOpsTaskInfo> lists(long batchId) throws SQLException {
        return new TaskStorageCommand(this.table).lists(this.devOpsDataSource, batchId);
    }
}

