package com.xforceplus.ultraman.adapter.elasticsearch;

import static com.xforceplus.metadata.schema.dsl.Step.APP;
import static com.xforceplus.metadata.schema.runtime.MetadataEngine.LABEL_INDEX;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.metadata.schema.dsl.metadata.__;
import com.xforceplus.metadata.schema.runtime.MetadataEngine;
import com.xforceplus.metadata.schema.utils.MetadataEngineHolder;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.sdk.core.datasource.route.TransportExecutor;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;
import com.xforceplus.ultraman.sdk.core.facade.ProfileFetcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.impl.AbstractSchema;

/**
 * lazy schema factory create schema from ultraman
 */
public class ElasticsearchSchemaFactory implements SchemaFactory {

  private MetadataEngine metadataEngine;

  private EntityClassEngine classEngine;

  private ContextService contextService;

  private ProfileFetcher fetcher;

  private ManageBocpMetadataService manageBocpMetadataService;


  private TransportExecutor transportExecutor;

  //private DynamicConfig dynamicConfig;

  public ElasticsearchSchemaFactory(MetadataEngine metadataEngin, EntityClassEngine classEngine,
      ContextService contextService, TransportExecutor elasticsearchTransportExecutor,
      ProfileFetcher fetcher,  ManageBocpMetadataService manageBocpMetadataService){
    this.metadataEngine = metadataEngin;
    this.fetcher = fetcher;
    this.contextService = contextService;
    this.classEngine = classEngine;
    this.transportExecutor = elasticsearchTransportExecutor;
    //this.dynamicConfig = dynamicConfig;
    this.manageBocpMetadataService = manageBocpMetadataService;
  }

  @Override
  public Schema create(SchemaPlus schemaPlus, String schema, Map<String, Object> map) {
    Map<String, AbstractSchema> mapping = new HashMap<>();
    List<Map<String, Object>> appList = metadataEngine.getMulti(__.has(LABEL_INDEX, APP));
    appList.forEach(x -> {
      String code = (String) x.get("code");
      ElasticsearchSchema elasticsearchSchema = new ElasticsearchSchema(transportExecutor, new ObjectMapper(),
          MetadataEngineHolder.get(), classEngine, fetcher, contextService, manageBocpMetadataService,code);

      schemaPlus.add(code, elasticsearchSchema);
      mapping.put(code, elasticsearchSchema);
    });
    return mapping.values().stream().findFirst()
        .orElseThrow(() -> new RuntimeException("No Schema Involved"));
  }
}
