package com.xforceplus.ultraman.adapter.elasticsearch.listener;

import com.alibaba.fastjson2.JSONObject;
import com.xforceplus.ultraman.adapter.elasticsearch.CustomElasticSearchTransport;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;
import com.xforceplus.ultraman.adapter.elasticsearch.service.IndexOperation;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.adapter.elasticsearch.service.utils.BocpMetabaseCacheUtils;
import com.xforceplus.ultraman.extensions.reporter.callback.NodeReporterBeforeSendCallback;
import com.xforceplus.ultraman.extensions.reporter.domain.NodeExtInfoDTO;
import com.xforceplus.ultraman.extensions.reporter.domain.NodeInfoDTO;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @ClassName ElasticSearchIndexConfig
 * @description:
 * @author: WanYi
 * @create: 2023-08-04 18:23
 * @Version 1.0
 */
@Slf4j
public class ElasticIndexConfigUpload implements NodeReporterBeforeSendCallback {

  @Autowired
  private IndexOperation engineAdapterService;
/*  @Autowired
  private EntityClassRelationService entityClassRelationService;*/
  @Autowired
  public EntityClassEngine entityClassEngine;

  @Autowired
  private CustomElasticSearchTransport customElasticSearchTransport;
  @Autowired
  private ManageBocpMetadataService manageBocpMetadataService;

  @Override
  public void modify(NodeInfoDTO nodeInfoDTO) {
    List<Tuple2<String, String>> errors = new ArrayList<>();
    List<String> bocpConfigAllKey = BocpMetabaseCacheUtils.getBocpConfigAllKey();
    Map<Long, List<NodeExtInfoDTO>> extInfos = new HashMap<>();
    if (nodeInfoDTO.getExtInfo() == null) {
      nodeInfoDTO.setExtInfo(extInfos);
    }
    bocpConfigAllKey.forEach(bocpConfigKey -> {
      Map<Long, BocpElasticConfigPo> bocpConfig = BocpMetabaseCacheUtils.getExactlyBocpConfig(bocpConfigKey);

      bocpConfig.values().forEach(bocpElasticConfigPo -> {
        IEntityClass iEntityClass = entityClassEngine.load(String.valueOf(bocpElasticConfigPo.getEntityClassId()), bocpConfigKey).get();
        try {
          List<String> entityClassMappingIndexs = manageBocpMetadataService.getEntityClassMappingIndexs(bocpConfigKey, iEntityClass);
          List<NodeExtInfoDTO> nodeExtInfoDTOS = new ArrayList<>();
          entityClassMappingIndexs.forEach(indexName -> {
            if (engineAdapterService.indexExists(indexName, bocpConfigKey)) {
              JSONObject indexStats = customElasticSearchTransport.getIndexStats(indexName, bocpConfigKey);
              NodeExtInfoDTO nodeExtInfoDTO = new NodeExtInfoDTO();
              nodeExtInfoDTO.setEntityClassId(bocpElasticConfigPo.getEntityClassId());
              nodeExtInfoDTO.setIndexName(indexName);
              nodeExtInfoDTO.setEntityClassCode(bocpElasticConfigPo.getEntityClassCode().toLowerCase());
              nodeExtInfoDTO.setIndexStats(indexStats.toJSONString());
              nodeExtInfoDTOS.add(nodeExtInfoDTO);
            }
          });
          if (nodeExtInfoDTOS.size() >= 1) {
            extInfos.put(bocpElasticConfigPo.getEntityClassId(), nodeExtInfoDTOS);
          }
        } catch (Throwable e) {
          logInfo(false, iEntityClass, errors, e.getMessage());
        }
      });

      if (!errors.isEmpty()) {
        StringBuilder sb = new StringBuilder();
        errors.stream().forEach(x -> {
          String entityCode = x._1;
          String reason = x._2;
          sb.append(entityCode).append(":").append(reason).append("|").append(System.lineSeparator());
        });
        log.error("FATAL --- get elasticsearch index stats infos failure. {}{}", System.lineSeparator(), sb);
      }
    });
  }

  /**
   * 表创建失败或异常时进行日志打印
   *
   * @param iEntityClass
   * @param status
   **/

  private void logInfo(boolean status, IEntityClass iEntityClass, List<Tuple2<String, String>> errors, String message) {
    if (!status) {
      errors.add(Tuple.of(iEntityClass.code(), Optional.ofNullable(message).orElse("NullPoint Exception")));
    }
  }
}
