package com.xforceplus.ultraman.adapter.elasticsearch.mock;


import com.xforceplus.ultraman.sdk.infra.lifecycle.BeanInitialization;
import com.xforceplus.ultraman.sdk.infra.utils.InitializationHelper;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import static com.xforceplus.ultraman.oqsengine.plus.common.utils.EnvMockConstant.*;


/**
 * Created by justin.xu on 06/2021.
 *
 * @since 1.8
 */
public class ElasticSearchInitialization implements BeanInitialization {

  private static volatile ElasticSearchInitialization instance = null;

  private RestHighLevelClient restHighLevelClient;
  private ExecutorService runner;

  private ElasticSearchInitialization() {

  }

  /**
   * 获取单例.
   */
  public static ElasticSearchInitialization getInstance() throws IllegalAccessException {
    if (null == instance) {
      synchronized (ElasticSearchInitialization.class) {
        if (null == instance) {
          instance = new ElasticSearchInitialization();
          instance.init();
          InitializationHelper.add(instance);
        }
      }
    }
    return instance;
  }

  @Override
  public void init() throws IllegalAccessException {
    runner = new ThreadPoolExecutor(RUNNER_CORE_POOL_SIZE, RUNNER_CORE_POOL_MAX_SIZE, 0,
        TimeUnit.SECONDS, new LinkedBlockingDeque<>(RUNNER_DEQUE_CAPACITY));
  }

  @Override
  public void clear() throws Exception {
    try {
      if (null != restHighLevelClient) {
        restHighLevelClient.close();
      }
    } catch (Exception e) {
      //  ignore
    }
  }

  @Override
  public void destroy() {
    if (null != restHighLevelClient) {
      try {
        restHighLevelClient.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
      restHighLevelClient = null;
    }

    runner.shutdown();
    runner = null;

    instance = null;
  }


  /**
   * get redisClient with lazy init.
   */

  public synchronized RestHighLevelClient getRestHighLevelClient() {
    if (null == restHighLevelClient) {
      restHighLevelClient = new RestHighLevelClient(
          RestClient.builder(
                  new HttpHost("172.25.8.77", 9200, "http"))
              .setHttpClientConfigCallback(httpClientBuilder -> {
                httpClientBuilder.disableAuthCaching();
                return httpClientBuilder;
              }));
      return restHighLevelClient;
    }
    return restHighLevelClient;
  }

  public ExecutorService getRunner() {
    return runner;
  }
}
