//package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;
//
//import com.google.common.collect.ImmutableList;
//import org.apache.calcite.adapter.jdbc.JdbcTable;
//import org.apache.calcite.plan.RelOptTable;
//import org.apache.calcite.rel.RelNode;
//import org.apache.calcite.rel.core.Filter;
//import org.apache.calcite.rel.core.TableScan;
//import org.apache.calcite.rel.hint.RelHint;
//import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
//import org.apache.calcite.sql.*;
//import org.apache.calcite.sql.parser.SqlParserPos;
//
//import java.util.stream.Collectors;
//import java.util.stream.Stream;
//
//import static java.util.Objects.requireNonNull;
//
//public class RelToSqlConverterEx extends RelToSqlConverter {
//    
//    /**
//     * Creates a RelToSqlConverter.
//     *
//     * @param dialect
//     */
//    public RelToSqlConverterEx(SqlDialect dialect) {
//        super(dialect);
//    }
//
//    @Override
//    public Result visit(Filter e) {
//        return super.visit(e);
//    }
//
//    @Override
//    public Result visit(TableScan e) {
//        final SqlIdentifier identifier = getSqlTargetTable(e);
//        final SqlNode node;
//        final ImmutableList<RelHint> hints = e.getHints();
//        if (!hints.isEmpty()) {
//            SqlParserPos pos = identifier.getParserPosition();
//            node = new SqlTableRef(pos, identifier,
//                    SqlNodeList.of(pos, hints.stream().map(h -> toSqlHint(h, pos))
//                            .collect(Collectors.toList())));
//        } else {
//            node = identifier;
//        }
//        Result result = result(node, ImmutableList.of(Clause.FROM), e, null);
//        result.builder()
//    }
//
//    private static SqlIdentifier getSqlTargetTable(RelNode e) {
//        // Use the foreign catalog, schema and table names, if they exist,
//        // rather than the qualified name of the shadow table in Calcite.
//        final RelOptTable table = requireNonNull(e.getTable());
//        return table.maybeUnwrap(JdbcTable.class)
//                .map(JdbcTable::tableName)
//                .orElseGet(() ->
//                        new SqlIdentifier(table.getQualifiedName(), SqlParserPos.ZERO));
//    }
//
//    private static SqlHint toSqlHint(RelHint hint, SqlParserPos pos) {
//        if (hint.kvOptions != null) {
//            return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos),
//                    SqlNodeList.of(pos, hint.kvOptions.entrySet().stream()
//                            .flatMap(
//                                    e -> Stream.of(new SqlIdentifier(e.getKey(), pos),
//                                            SqlLiteral.createCharString(e.getValue(), pos)))
//                            .collect(Collectors.toList())),
//                    SqlHint.HintOptionFormat.KV_LIST);
//        } else if (hint.listOptions != null) {
//            return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos),
//                    SqlNodeList.of(pos, hint.listOptions.stream()
//                            .map(e -> SqlLiteral.createCharString(e, pos))
//                            .collect(Collectors.toList())),
//                    SqlHint.HintOptionFormat.LITERAL_LIST);
//        }
//        return new SqlHint(pos, new SqlIdentifier(hint.hintName, pos),
//                SqlNodeList.EMPTY, SqlHint.HintOptionFormat.EMPTY);
//    }
//}
