//package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;
//
//import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
//import com.xforceplus.ultraman.metadata.entity.IEntityField;
//import io.vavr.Tuple;
//import io.vavr.Tuple2;
//import io.vavr.Tuple3;
//import java.util.LinkedList;
//import java.util.List;
//import java.util.Optional;
//import java.util.Queue;
//import java.util.Stack;
//import java.util.concurrent.atomic.AtomicInteger;
//import org.apache.calcite.plan.RelOptTable;
//import org.apache.calcite.rel.BiRel;
//import org.apache.calcite.rel.RelNode;
//import org.apache.calcite.rel.core.Aggregate;
//import org.apache.calcite.rel.core.Join;
//import org.apache.calcite.rel.core.Project;
//import org.apache.calcite.rel.core.TableScan;
//import org.apache.calcite.rel.type.RelDataType;
//import org.apache.calcite.rel.type.RelDataTypeField;
//import org.apache.calcite.rex.RexNode;
//import org.apache.calcite.tools.RelBuilder;
//
///**
// *
// */
//public class RexNodeHelper {
//
//
//  private static RelBuilder newBuilder;
//
//  public static Tuple2<EntityClassGroup, RelDataTypeField> findSource(int index, List<EntityClassGroup> relatedGroup, RelNode currentNode,
//      boolean isStart, Queue<Boolean> footprint) {
//    if (currentNode instanceof TableScan || (currentNode instanceof Project && !isStart) || currentNode instanceof Aggregate) {
//      //terminate condition
//      RelDataTypeField relDataTypeField = currentNode.getRowType().getFieldList().get(index);
//      EntityClassGroup relatedEntityClass = findRelatedEntityClass(currentNode, relatedGroup);
//      return Tuple.of(relatedEntityClass, relDataTypeField);
//    } else if (currentNode instanceof BiRel) {
//      //biRel will find in left or right
//      RelNode left = ((Join) currentNode).getLeft();
//      RelNode right = ((Join) currentNode).getRight();
//
//      int leftSize = left.getRowType().getFieldList().size();
//      if (index >= leftSize) {
//        footprint.add(true);
//        return findSource(index - leftSize, relatedGroup, right, false, footprint);
//      } else {
//        footprint.add(false);
//        return findSource(index, relatedGroup, left, false, footprint);
//      }
//    } else {
//      //rowDataType is from parent
//      return findSource(index, relatedGroup, currentNode.getInput(0), false, footprint);
//    }
//  }
//
//  /**
//   * find target relNode
//   *
//   * @param footprint  is from old tree as a hint to find in new tree where the relNode is located
//   * @param relBuilder
//   * @return
//   */
//  private static Tuple3<Integer, RelNode, Integer> findTarget(Queue<Boolean> footprint, RelBuilder relBuilder, int size) {
//    int i = 0;
//    AtomicInteger offSet = new AtomicInteger(0);
//    if (size > 1) {
//      //join
//      Boolean isRight = footprint.poll();
//      if (isRight) {
//        i = 1;
//        offSet.addAndGet(relBuilder.peek(0).getRowType().getFieldCount());
//        return Tuple.of(i, findTarget(footprint, relBuilder.peek(0), offSet), offSet.get());
//      } else {
//        return Tuple.of(i, findTarget(footprint, relBuilder.peek(1), offSet), offSet.get());
//      }
//    } else {
//      return Tuple.of(i, findTarget(footprint, relBuilder.peek(), offSet), offSet.get());
//    }
//  }
//
//  /**
//   * find in relNode
//   *
//   * @param footprint
//   * @param relNode
//   * @return
//   */
//  private static RelNode findTarget(Queue<Boolean> footprint, RelNode relNode, AtomicInteger offSet) {
//    if (relNode instanceof BiRel) {
//      RelNode left = ((BiRel) relNode).getLeft();
//      RelNode right = ((BiRel) relNode).getRight();
//      Boolean isRight = footprint.poll();
//      if (isRight) {
//        offSet.addAndGet(left.getRowType().getFieldCount());
//        return findTarget(footprint, right, offSet);
//      } else {
//        return findTarget(footprint, left, offSet);
//      }
//    } else if (relNode instanceof Project || relNode instanceof TableScan || relNode instanceof Aggregate) {
//      return relNode;
//    } else {
//      RelNode input = relNode.getInput(0);
//      return findTarget(footprint, input, offSet);
//    }
//  }
//
//  /**
//   * convert current inputRef from current relNode to a new rexNode in newBuilder current cover case current node - project - filter - join condition
//   * - sort
//   *
//   * @param newBuilder
//   * @param index
//   * @param relatedGroup
//   * @param currentNode
//   * @return
//   */
//  public static RexNode convert(RelBuilder newBuilder, int index
//      , List<EntityClassGroup> relatedGroup
//      , RelNode currentNode
//      , boolean isStart, int totalNum) {
//
//    Queue<Boolean> footprint = new LinkedList<>();
//    Tuple2<EntityClassGroup, RelDataTypeField> source = findSource(index, relatedGroup, currentNode, isStart, footprint);
//    EntityClassGroup entityClass = source._1;
//    RelDataTypeField relDataTypeField = source._2;
//    Tuple3<Integer, RelNode, Integer> targetNode;
//    /**
//     * find target cannot depend on index should with hint from findSource
//     */
//    if (currentNode instanceof BiRel && newBuilder.size() > 1) {
//      targetNode = findTarget(footprint, newBuilder, 2);
//    } else {
//      targetNode = findTarget(footprint, newBuilder, 1);
//    }
//
//    /**
//     * find in newBuilder the index also can give a hint to search in inputNode
//     */
//    String originName = relDataTypeField.getName();
//    String targetName = originName.toLowerCase();
//
//    Optional<IEntityField> fieldOp;
//    if (targetName.startsWith("_") && targetName.contains(".")) {
//      //should transform to current node
//      int i = targetName.lastIndexOf(".");
//      fieldOp = entityClass.field(targetName.substring(i + 1));
//    } else {
//      fieldOp = entityClass.field(targetName);
//    }
//
//    if (fieldOp.isPresent()) {
//      /**
//       * only when dataType has a _related code we should do the match
//       * if in a project already done this we return the raw name
//       */
//      String finalTargetName = targetName;
//      RelNode targetRelNode = targetNode._2;
//      Optional<RelDataTypeField> related = targetRelNode.getRowType().getFieldList().stream().filter(x -> isFitName(x.getName(), finalTargetName)
//      ).findFirst();
//
//      if (related.isPresent()) {
//        //has same code
//        if (currentNode instanceof BiRel && newBuilder.size() > 1) {
//          Integer ptx = targetNode._1;
//          return newBuilder.field(totalNum, ptx, related.get().getIndex());
//        } else {
//          return newBuilder.field(1, 0, related.get().getIndex() + targetNode._3);
//        }
//
//      } else {
//        throw new RuntimeException("No Related Code:" + finalTargetName);
//      }
//
//    } else {
//      List<String> fieldNames;
//      if (currentNode instanceof BiRel) {
//        Integer ptx = targetNode._1;
//        RelNode peek = newBuilder.peek();
//        if (newBuilder.size() > 1) {
//          //have no join
//          fieldNames = newBuilder.peek(1 - ptx).getRowType().getFieldNames();
//          int i = fieldNames.indexOf(originName);
//          return newBuilder.field(totalNum, ptx, i);
//        } else if (peek instanceof BiRel) {
//          fieldNames = newBuilder.peek().getInput(1 - ptx).getRowType().getFieldNames();
//          if (ptx == 0) {
//            //left
//            int i = fieldNames.indexOf(originName);
//            if (i > -1) {
//              return newBuilder.field(1, 0, i);
//            } else {
//              return newBuilder.field(1, 0, originName);
//            }
//          } else {
//            //right
//            int i = fieldNames.indexOf(originName);
//            if (i > -1) {
//              return newBuilder.field(totalNum, ptx, i + newBuilder.peek().getInput(0).getRowType().getFieldCount());
//            } else {
//              return newBuilder.field(totalNum, ptx, originName);
//            }
//
//          }
//        } else if (peek.getInput(0) instanceof BiRel) {
//          fieldNames = newBuilder.peek().getInput(0).getInput(ptx).getRowType().getFieldNames();
//          if (ptx == 0) {
//            //left
//            int i = fieldNames.indexOf(originName);
//            return newBuilder.field(totalNum, ptx, i);
//          } else {
//            //right
//            int i = fieldNames.indexOf(originName);
//            return newBuilder.field(totalNum, ptx, i + newBuilder.peek().getInput(0).getInput(0).getRowType().getFieldCount());
//          }
//        }
//      }
//
//      fieldNames = newBuilder.peek().getRowType().getFieldNames();
//      int i = fieldNames.indexOf(originName);
//      return newBuilder.field(totalNum, 0, i);
//    }
//  }
//
//  private static boolean fieldIn(RelDataType rowType, String targetName) {
//    RelDataTypeField field = rowType.getField(targetName, false, false);
//    return field != null;
//  }
//
//  public static RexNode simpleNameConvert(RelBuilder newBuilder, EntityClassGroup entityClass, String
//      originName, String targetName, int totalNum, int inputIndex, boolean isRight) {
//
//    Optional<IEntityField> fieldOp = entityClass.field(targetName);
//    if (fieldOp.isPresent()) {
//      IEntityField field = fieldOp.get();
//      /**
//       * only when dataType has a _related code we should do the match
//       * if in a project already done this we return the raw name
//       */
//      String finalTargetName = targetName;
//
//      /**
//       * filter join
//       */
//
//      RelNode peeked = newBuilder.peek(inputIndex - 1);
//      Optional<RelDataTypeField> first = null;
//      if (peeked instanceof Join) {
//        if (isRight) {
//          first = ((Join) peeked).getRight().getRowType()
//              .getFieldList().stream().filter(x -> isFitName(x.getName(), finalTargetName)
//              ).findFirst();
//        } else {
//          first = ((Join) peeked).getLeft().getRowType()
//              .getFieldList().stream().filter(x -> isFitName(x.getName(), finalTargetName)
//              ).findFirst();
//        }
//      } else {
//        first = newBuilder.peek(inputIndex - 1).getRowType()
//            .getFieldList().stream().filter(x -> isFitName(x.getName(), finalTargetName)
//            ).findFirst();
//      }
//
//      /**
//       * ignore case to find the field
//       */
//      if (first.isPresent()) {
//        //build origin
//        /**
//         * join
//         */
//        //find field position
//        RelDataTypeField targetField = first.get();
//        int targetIndex = targetField.getIndex();
//
//        if (!isRight) {
//          //in left
//          return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
//        } else {
//          if (peeked instanceof Join) {
//            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0,
//                targetIndex + ((Join) peeked).getLeft().getRowType().getFieldCount());
//          } else {
//            return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetIndex);
//          }
//        }
//      } else {
//        //throw exception
//        return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, targetName);
//      }
//
//    }
//
//    //in case duplicate we should find the mapping from NAME to RefIndex
//    List<String> fieldNames = newBuilder.peek().getRowType().getFieldNames();
//    int i = fieldNames.indexOf(originName);
//    if (i > 0) {
//      return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, i);
//    } else {
//      return newBuilder.field(totalNum, totalNum > 1 ? 2 - inputIndex : 0, originName);
//    }
//  }
//
//  private static EntityClassGroup findRelatedEntityClass(RelNode relNode, List<EntityClassGroup> allRelatedEntityClasses) {
//    Stack<RelNode> stack = new Stack<>();
//    stack.push(relNode);
//    while (!stack.isEmpty()) {
//      RelNode next = stack.pop();
//      if (next instanceof TableScan) {
//        RelOptTable table = ((TableScan) next).getTable();
//        String entityCode = table.getQualifiedName().get(1);
//        Optional<EntityClassGroup> first = allRelatedEntityClasses.stream()
//            .filter(x -> x.getEntityClass().code().equalsIgnoreCase(entityCode)).findFirst();
//        if (first.isPresent()) {
//          return first.get();
//        }
//      } else {
//        //TODO current we treat the combined relNode as single always get the left one
//        //but we may get following case  BiRel or SingleRel
//        if (next instanceof BiRel) {
//          RelNode input = next.getInput(0);
//          stack.push(input);
//        } else {
//          RelNode input = next.getInput(0);
//          stack.push(input);
//        }
//      }
//    }
//
//    throw new RuntimeException("No Related EntityClass");
//  }
//
//  private static boolean isFitName(String name, String finalTargetName) {
//    if (name.equalsIgnoreCase(finalTargetName)) {
//      return true;
//    } else {
//      String transformed = finalTargetName.replaceAll("\\.", "_");
//      if (name.equalsIgnoreCase(transformed)) {
//        return true;
//      }
//    }
//
//    return false;
//  }
//}
