package com.xforceplus.ultraman.adapter.elasticsearch.rules;

import com.xforceplus.ultraman.adapter.elasticsearch.ElasticsearchRel;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;

/**
 * @program: ultraman-oqsengine-plus
 * @ClassName ElasticsearchJoin
 * @description:
 * @author: WanYi
 * @create: 2023-06-02 17:30
 * @Version 1.0
 **/
public class ElasticsearchJoin extends Join implements ElasticsearchRel {

  public ElasticsearchJoin(RelOptCluster cluster, RelTraitSet traitSet,
      List<RelHint> hints, RelNode left,
      RelNode right, RexNode condition,
      Set<CorrelationId> variablesSet, JoinRelType joinType) {
    super(cluster, traitSet, hints, left, right, condition, variablesSet, joinType);
  }

  @Override
  public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right,
      JoinRelType joinType, boolean semiJoinDone) {
    return new ElasticsearchJoin(getCluster(), traitSet, getHints(), left, right, condition,
        getVariablesSet(), joinType);
  }


  @Override
  public void implement(Implementor implementor) {
    implementor.visitChild(0, getLeft());
    implementor.visitChild(0, getRight());

    if (!getCondition().isA(SqlKind.EQUALS)) {
      throw new IllegalArgumentException("Only equi-join are supported");
    }
    List<RexNode> operands = ((RexCall) getCondition()).getOperands();
    if (operands.size() != 2) {
      throw new IllegalArgumentException("Only equi-join are supported");
    }
  }
}
