package com.xforceplus.ultraman.adapter.elasticsearch.service.adatper;

import com.xforceplus.ultraman.cdc.adapter.CDCBeforeCallback;
import com.xforceplus.ultraman.metadata.cdc.OqsEngineEntity;
import com.xforceplus.ultraman.metadata.domain.record.Record;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.facade.result.QueryResult;
import com.xforceplus.ultraman.sdk.core.rel.legacy.*;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@Slf4j
public class CompleteOqsEntity implements CDCBeforeCallback {

    @Autowired
    private EntityFacade entityFacade;

    @Override
    public String name() {
        return getClass().getName();
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

    @Override
    public void mutate(List<OqsEngineEntity> oqsEngineEntities) {
        Map<Tuple2<Long, Object>, List<OqsEngineEntity>> grouped = oqsEngineEntities.stream().filter(x -> {
            return !x.isIntact();
        }).collect(Collectors.groupingBy(x -> Tuple.of(x.getEntityClassRef().getId(), Optional.ofNullable(x.getAttributes().get("_sys_profile")).orElse(""))));

        grouped.forEach((k, v) -> {
            Optional<IEntityClass> targetOp = entityFacade.load(Long.toString(k._1), (String) k._2());
            if (targetOp.isPresent()) {
                EntityClassGroup group = entityFacade.getEntityClassEngine().describe(targetOp.get(), (String) k._2());
                log.warn("Trigger {} complete, this will get newest state and maybe rollback afterwards", k);
                IEntityClass entityClass = targetOp.get();
                List<Long> collect = v.stream().map(x -> x.getId()).collect(Collectors.toList());
                ExpQuery expQuery = new ExpQuery().range(1, collect.size());
                expQuery.filters(ExpCondition.call(ExpOperator.IN, ExpField.ID, ExpValue.from(collect)));
                CompletionStage<Either<QueryResult, DataCollection<Record>>> query = entityFacade.query(entityClass, expQuery, Collections.emptyMap());
                try {
                    Either<QueryResult, DataCollection<Record>> dataCollections = query.toCompletableFuture().get();
                    if(dataCollections.isRight()) {
                        //fillV
                        fillOqsEntities(group, dataCollections.get().getRows(), v);
                    } else {
                        log.error(dataCollections.getLeft().getMessage());
                    }
                } catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fillOqsEntities(EntityClassGroup group, List<Record> rows, List<OqsEngineEntity> v) {
        Map<Long, OqsEngineEntity> mapping = v.stream().collect(Collectors.toMap(x -> x.getId(), y -> y, (a, b) -> b));
        rows.forEach(row -> {
            Long id = row.getId();
            OqsEngineEntity oqsEngineEntity = mapping.get(id);
            if(oqsEngineEntity != null) {
                group.getAllFields().forEach(f -> {
                    oqsEngineEntity.getAttributes().put(f.name(), row.get(f.name()).orElse(null));
                });
            }
        });
    }
}
