package com.xforceplus.ultraman.adapter.elasticsearch.service.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.ultraman.adapter.elasticsearch.query.po.BocpElasticConfigPo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName BocpMetabaseCacheUtils
 * @description:
 * @author: WanYi
 * @create: 2023-08-14 14:12
 * @Version 1.0
 **/
@Slf4j
public class BocpMetabaseCacheUtils {

    /**
     * 缓存是否过期
     */
    private static final long GUAVA_CACHE_DAY = 15;


    /**
     * 缓存index索引分拆对象,key值为profile,value值为Bocp租户Segment配置信息
     */
    private static LoadingCache<String, Map<Long, Map<String, String>>> INDEX_MAPPING_CACHE = null;

    /**
     * 缓存Bocp segment映射拆分规则
     **/
    private static LoadingCache<String, Map<Long, BocpElasticConfigPo>> BOCP_CONFIG_CACHE = null;

    static {
        try {
            INDEX_MAPPING_CACHE = loadIndexMappingCache(new CacheLoader<String, Map<Long, Map<String, String>>>() {
                @Override
                public Map<Long, Map<String, String>> load(String key) {
                    /**当缓存中没有命中对应的profile值时，索引es对应的集群索引**/
                    return null;
                }
            });
            BOCP_CONFIG_CACHE = loadBocpConfigCache(new CacheLoader<String, Map<Long, BocpElasticConfigPo>>() {
                @Override
                public Map<Long, BocpElasticConfigPo> load(String key) {
                    /**当缓存中没有命中对应的profile值时，索引es对应的集群索引**/
                    return null;
                }
            });
        } catch (Exception e) {
            log.error("初始化Guava Cache出错", e);
        }
    }

    /**
     * 全局缓存设置
     * <p>
     *
     * @param cacheLoader
     * @return
     * @throws Exception
     */
    private static LoadingCache<String, Map<Long, Map<String, String>>> loadIndexMappingCache(
            CacheLoader<String, Map<Long, Map<String, String>>> cacheLoader) {
        LoadingCache<String, Map<Long, Map<String, String>>> cache = CacheBuilder.newBuilder()
                /**当缓存的profile,半个月内没有访问时，将期过期并从cache中删除，暂时注释掉过期时间**/
                //.expireAfterAccess(GUAVA_CACHE_DAY, TimeUnit.DAYS)
                .recordStats()
                .build(cacheLoader);
        return cache;
    }


    /**
     * 全局缓存设置
     * <p>
     *
     * @param cacheLoader
     * @return
     * @throws Exception
     */
    private static LoadingCache<String, Map<Long, BocpElasticConfigPo>> loadBocpConfigCache(
            CacheLoader<String, Map<Long, BocpElasticConfigPo>> cacheLoader) {
        LoadingCache<String, Map<Long, BocpElasticConfigPo>> cache = CacheBuilder.newBuilder()
                /**当缓存的profile,半个月内没有访问时，将期过期并从cache中删除，暂时注释掉过期时间**/
                //.expireAfterAccess(GUAVA_CACHE_DAY, TimeUnit.DAYS)
                .recordStats()
                .build(cacheLoader);
        return cache;
    }

    /**
     * 设置缓存值 注: 若已有该key值，则会先移除(会触发removalListener移除监听器)，再添加
     *
     * @param key
     * @param value
     */
    public static void putIndexMapping(String key, Map<Long, Map<String, String>> value) {
        try {
            INDEX_MAPPING_CACHE.put(key, value);
        } catch (Exception e) {
            log.warn("设置缓存值出错", e);
        }
    }


    public static void putBocpConfig(String key, Map<Long, BocpElasticConfigPo> value) {
        try {
            BOCP_CONFIG_CACHE.put(key, value);
        } catch (Exception e) {
            log.warn("设置缓存值出错", e);
        }
    }

    /**
     * 获取缓存值 注：如果键不存在值，将调用CacheLoader的load方法加载新值到该键中
     *
     * @param key
     * @return
     */
    public static Map<Long, Map<String, String>> getIndexMapping(String key) {
        Map<Long, Map<String, String>> token = null;
        try {
            token = INDEX_MAPPING_CACHE.get(key);
        } catch (Exception e) {
        }

        if (token == null && !"default".equalsIgnoreCase(key)) {
            try {
                token = INDEX_MAPPING_CACHE.get("default");
            } catch (Exception e) {

            }
        }
        return token;
    }

    public static Map<Long, Map<String, String>> getExactlyIndexMapping(String key) {
        Map<Long, Map<String, String>> token = null;
        try {
            token = INDEX_MAPPING_CACHE.get(key);
        } catch (Exception e) {
        }
        
        return token;
    }

    public static Map<Long, BocpElasticConfigPo> getExactlyBocpConfig(String key) {
        Map<Long, BocpElasticConfigPo> token = null;
        try {
            token = BOCP_CONFIG_CACHE.get(key);
        } catch (Exception e) {

        }
        
        return token;
    }
    
    public static Map<Long, BocpElasticConfigPo> getBocpConfig(String key) {
        Map<Long, BocpElasticConfigPo> token = null;
        try {
            token = BOCP_CONFIG_CACHE.get(key);
        } catch (Exception e) {
        
        }

        if (token == null && !"default".equalsIgnoreCase(key)) {
            try {
                token = BOCP_CONFIG_CACHE.get("default");
            } catch (Exception e) {

            }
        }
        return token;
    }

    /**
     * 获取缓存值 注：如果键不存在值，将调用CacheLoader的load方法加载新值到该键中
     *
     * @return
     */
    public static List<String> getIndexMappingAllKey() {
        try {
            return new ArrayList<>(INDEX_MAPPING_CACHE.asMap().keySet());
        } catch (Exception e) {
        }
        return null;
    }

    public static List<String> getBocpConfigAllKey() {
        try {
            return new ArrayList<>(BOCP_CONFIG_CACHE.asMap().keySet());
        } catch (Exception e) {
        }
        return null;
    }


    /**
     * 移除缓存
     *
     * @param key
     */
    public static void removeIndexMapping(String key) {
        try {
            INDEX_MAPPING_CACHE.invalidate(key);
        } catch (Exception e) {
        }
    }

    public static void removeBocpConfig(String key) {
        try {
            BOCP_CONFIG_CACHE.invalidate(key);
        } catch (Exception e) {
        }
    }

    /**
     * 批量移除缓存
     *
     * @param keys
     */
    public static void removeAllIndexMapping(Iterable<String> keys) {
        try {
            INDEX_MAPPING_CACHE.invalidateAll(keys);
        } catch (Exception e) {
        }
    }

    public static void removeAllBocpConfig(Iterable<String> keys) {
        try {
            BOCP_CONFIG_CACHE.invalidateAll(keys);
        } catch (Exception e) {
        }
    }

    /**
     * 清空所有缓存
     */
    public static void removeAllIndexMapping() {
        try {
            INDEX_MAPPING_CACHE.invalidateAll();
        } catch (Exception e) {
        }
    }

    /**
     * 清空所有缓存
     */
    public static void removeAllBocpConfig() {
        try {
            BOCP_CONFIG_CACHE.invalidateAll();
        } catch (Exception e) {
        }
    }


    /**
     * 获取缓存项数量
     *
     * @return
     */
    public static long indexMappngSize() {
        long size = 0;
        try {
            size = INDEX_MAPPING_CACHE.size();
        } catch (Exception e) {
        }
        return size;
    }

    public static long bocpConfigSize() {
        long size = 0;
        try {
            size = BOCP_CONFIG_CACHE.size();
        } catch (Exception e) {
        }
        return size;
    }
}
