package com.xforceplus.ultraman.adapter.elasticsearch.strategy;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.strategy.QueryProviderSelectStrategy;
import com.xforceplus.ultraman.sdk.core.config.CdcConfig;
import io.vavr.Tuple2;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ESQueryStrategy implements QueryProviderSelectStrategy {

    private ContextService contextService;

    private CdcConfig cdcConfig;

    private EntityClassEngine engine;

    public ESQueryStrategy(ContextService contextService, EntityClassEngine engine, CdcConfig cdcConfig) {
        this.contextService = contextService;
        this.cdcConfig = cdcConfig;
        this.engine = engine;
    }

    @Override
    public String name() {
        return "elasticsearch";
    }

    @Override
    public Map<DataQueryProvider, Double> score(String s, IEntityClass iEntityClass, String s1, RelDataType relDataType, List<RexNode> list, List<Map.Entry<String, Tuple2<StructKind, Class>>> list1, List<Pair<RexNode, String>> list2, List<Map.Entry<String, RelFieldCollation.Direction>> list3, Long aLong, Long aLong1, List<String> list4, List<AggregateCall> list5, List<RelHint> list6, RelNode relNode, DataContext dataContext, List<DataQueryProvider> dataQueryProviders) {
        Map<DataQueryProvider, Double> map = new HashMap<>();
        Object page = contextService.getAll().get("PAGE");
        EntityClassGroup group = engine.describe(iEntityClass, "");
        dataQueryProviders.stream().filter(x -> x.type() == DataQueryProvider.QueryProviderType.INDEX).forEach(x -> {
            if (!cdcConfig.getInclude().isEmpty()) {
                List<String> includeList = cdcConfig.getInclude();
                if (includeList.stream().anyMatch(code -> isAccept(group, code))) {
                    map.put(x, 10d);
                } else {
                    map.put(x, -10d);
                }
            } else {
                if (!cdcConfig.getExclude().isEmpty()) {
                    List<String> excludeList = cdcConfig.getExclude();
                    if (excludeList.stream().anyMatch(code -> isAccept(group, code))) {
                        map.put(x, -10d);
                    } else {
                        map.put(x, 10d);
                    }
                } else {
                    if (page != null) {
                        map.put(x, 1d);
                    }
                }
            }
        });

        return map;
    }

    private boolean isAccept(EntityClassGroup group, String code) {
        Set<String> fatherCodes = group.getFatherEntityClass().stream()
                .map(IEntityClass::code).collect(Collectors.toSet());
        return group.getEntityClass().code().equalsIgnoreCase(code) || fatherCodes.contains(code);
    }
}
