package com.xforceplus.ultraman.adapter.elasticsearch.utils;

import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.CommonProperty;
import com.xforceplus.ultraman.sdk.core.datasource.route.dynamic.config.DynamicConfig;

import java.util.Locale;

import org.apache.commons.lang.StringUtils;

/**
 * @ClassName DynamicConfigUtils
 * @description:
 * @author: WanYi
 * @create: 2023-06-28 15:18
 * @Version 1.0
 **/
public class DynamicConfigUtils {

    /**
     * 根据profile判断租户是否属于隔离专属租户,如果是隔离租户，返回重定向后索引库名称
     *
     * @param profile
     * @param dynamicConfig
     * @param appCode
     * @param idxName
     * @return
     **/
    public static String insulateTenant(DynamicConfig dynamicConfig, String profile, String idxName,
                                        String appCode) {
        if ((dynamicConfig != null && dynamicConfig.getIndexRouting().containsKey(profile))) {
            idxName = profile.concat("_").concat(appCode).concat("_").concat(idxName);
        } else {
            idxName = appCode.concat("_").concat(idxName);
        }
        return idxName.toLowerCase();
    }

    /**
     * @param profile
     * @param dynamicConfig
     * @param appCode
     **/
    public static String insulateTenant(DynamicConfig dynamicConfig, String profile, String appCode) {
        String prefix = "";
        if ((dynamicConfig != null && dynamicConfig.getIndexRouting().containsKey(profile))) {
            prefix = profile.concat("_").concat(appCode).concat("_");
        } else {
            prefix = appCode.concat("_");
        }
        return prefix.toLowerCase();
    }


    private static boolean getProfile(String profile) {
        if (StringUtils.isNotEmpty(profile) && !StringUtils.equalsIgnoreCase(profile, CommonProperty.defaultProfile)) {
            return true;
        }
        return false;
    }

    /**
     * 根据profile判断租户是否属于隔离专属租户,如果是隔离租户，返回重定向后索引库名称
     *
     * @param profile
     * @param appCode
     * @param idxName
     * @return
     **/
    public static String insulateTenant(String profile, String idxName, String appCode) {
        if (StringUtils.isNotEmpty(profile) && StringUtils.equalsIgnoreCase(profile, "default")) {
            idxName = profile.concat("_")
                    .concat(appCode).concat("_").concat(idxName);
        } else {
            idxName = appCode.concat("_").concat(idxName);
        }
        return idxName.toLowerCase();
    }
}

