package com.xforceplus.ultraman.adapter.elasticsearch.utils;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader.Feature;
import com.xforceplus.ultraman.adapter.elasticsearch.config.BocpElasticsearchConfiguration;
import com.xforceplus.ultraman.adapter.elasticsearch.query.dto.BocpElasticConfigDto;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName ParseBocpJsonUtils
 * @description:
 * @author: WanYi
 * @create: 2023-08-09 21:27
 * @Version 1.0
 **/
public class ParseBocpJsonUtils {

  /**
   * 解析事件监听回传的bocp配置信息
   *
   * @param bocpJson
   * @return
   **/
  public static BocpElasticsearchConfiguration parseBocpJson(String bocpJson) {
    List<BocpElasticConfigDto> bocpEntitys = JSONObject.parseObject(bocpJson).
        getJSONArray("bocp_entitys").toJavaList(BocpElasticConfigDto.class, Feature.IgnoreSetNullValue, Feature.TrimString);
    return BocpElasticsearchConfiguration.builder().bocpElasticConfigs(bocpEntitys).build();
  }
}
