package com.xforceplus.ultraman.adapter.elasticsearch.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.adapter.elasticsearch.query.dto.BocpElasticConfigDto;
import java.util.List;

import com.xforceplus.ultraman.sdk.core.config.TenantedConfig;
import lombok.Builder;
import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @ClassName BocpElasticsearchConfiguration
 * @description:
 * @author: WanYi
 * @create: 2023-08-09 21:20
 * @Version 1.0
 **/

@ConditionalOnProperty("xplat.elasticsearch.bocp")
@ConfigurationProperties(prefix = "xplat.elasticsearch.bocp")
@Data
@Builder
public class BocpElasticsearchConfiguration {

  @JsonProperty("bocp_entitys")
  private List<BocpElasticConfigDto> bocpElasticConfigs;
}
