package com.xforceplus.ultraman.adapter.elasticsearch.query;


import com.xforceplus.ultraman.adapter.elasticsearch.query.exception.ElasticSqlValidatorException;
import java.util.Stack;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.jetbrains.annotations.NotNull;

@Slf4j
public class ElasticCustomShuttle implements RelShuttle {


  private boolean joinQuery = false;
  private int joinUpperLimit = 2;

  /**
   * a stack to find out current part
   */
  private Stack<String> termStack = new Stack<>();


  @Override
  public RelNode visit(@NotNull TableScan scan) {
    if (currentStackHas("OqsengineJoin")) {
      if (termStack.size() > joinUpperLimit) {
        log.error("elasticsearch is not supported More than three join queries.");
        throw new ElasticSqlValidatorException("elasticsearch is not supported More than three join queries,please\n"
            + "Modify the SQL or Select other the query engine");
      }
    }
    return scan;
  }

  @Override
  public RelNode visit(TableFunctionScan scan) {
    return null;
  }

  @Override
  public RelNode visit(LogicalValues values) {
    return null;
  }

  @Override
  public RelNode visit(LogicalFilter filter) {
    return null;
  }

  @Override
  public RelNode visit(LogicalCalc calc) {
    return null;
  }

  @Override
  public RelNode visit(LogicalProject project) {
    return null;
  }

  @Override
  public RelNode visit(LogicalJoin join) {
    return null;
  }

  @Override
  public RelNode visit(LogicalCorrelate correlate) {
    return null;
  }

  @Override
  public RelNode visit(LogicalUnion union) {
    return null;
  }

  @Override
  public RelNode visit(LogicalIntersect intersect) {
    return null;
  }

  @Override
  public RelNode visit(LogicalMinus minus) {
    return null;
  }

  @Override
  public RelNode visit(LogicalAggregate aggregate) {
    return null;
  }

  @Override
  public RelNode visit(LogicalMatch match) {
    return null;
  }

  @Override
  public RelNode visit(LogicalSort sort) {
    return null;
  }

  @Override
  public RelNode visit(LogicalExchange exchange) {
    return null;
  }

  @Override
  public RelNode visit(LogicalTableModify modify) {
    return null;
  }

  private boolean currentStackHas(String term) {
    int termSearch = termStack.search(term);
    if (termSearch > 0) {
      return true;
    } else {
      return false;
    }
  }

  @Override
  public RelNode visit(RelNode other) {
    if (other instanceof Join) {
      termStack.push(other.getRelTypeName());
    }
    other.getInputs().forEach(x -> x.accept(this));
    return null;
  }

  public boolean getJoinsCounter() {
    return termStack.size() >= 1 ? true : false;
  }
}
