package com.xforceplus.ultraman.adapter.elasticsearch.query.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ClassName BocpElasticConfig
 * @description:
 * @author: WanYi
 * @create: 2023-08-10 09:26
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class BocpElasticConfigDto implements Serializable {

  /**
   * 开启同步至elastic
   **/
  @JsonProperty("enable_sync")
  private boolean enableSync;

  /**
   * 实例对象ID
   **/
  @JsonProperty("entity_class_id")
  private long entityClassId;

  /**
   * 实例对象code
   **/
  @JsonProperty("entity_class_code")
  private String entityClassCode;
  
  /**
   * 定制化租户配置信息
   **/
  @JsonProperty("elastic_tenant_profiles")
  private List<ElasticTenantProfile> elasticTenantProfiles;


  /**
   * 默认索引是否需要拆分
   **/
  @JsonProperty("self_segment_rule")
  private ElasticTenantProfile selfSegmentRule;

}
