package com.xforceplus.ultraman.adapter.elasticsearch.query.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Builder;
import lombok.Data;

/**
 * @ClassName ElasticTenantProfile
 * @description:
 * @author: WanYi
 * @create: 2023-08-14 10:02
 * @Version 1.0
 **/
@Data
@Builder
public class ElasticTenantProfile implements Serializable {

  /**
   * 开启大索引折份状态
   **/
  @JsonProperty("enable_segment")
  private boolean enableSegment;
  /**
   * 大索引拆分业务字段
   **/
  @JsonProperty("segment_field")
  private String segmentField;

  /**
   * 大索引拆分字段存储类型
   **/
  @JsonProperty("segment_field_type")
  private String segmentFieldType;
  /**
   * 解析对应分割索引字段的格式 字段字段指定yyyy-mm-dd 等格式化字符串 备用补充字段
   **/
  @JsonProperty("segment_date_format")
  private String segmentDateFormat;
  /**
   * 按年或者是季度来拆分索引,或者是按字段范围拆
   **/
  @JsonProperty("segment_rule")
  private String segmentRule;

  /**
   * 租户tenantCode
   **/
  @JsonProperty("tenant_code")
  private String tenantCode;
}
