package com.xforceplus.ultraman.adapter.elasticsearch.query.po;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SegmentFieldType;
import com.xforceplus.ultraman.adapter.elasticsearch.service.constant.SegmentIndexRule;
import lombok.Builder;
import lombok.Data;

/**
 * @ClassName BocpElasticConfigPo
 * @description:
 * @author: WanYi
 * @create: 2023-08-15 14:35
 * @Version 1.0
 **/
@Data
@Builder
public class BocpElasticConfigPo {

  /**
   * bocp配置映射对应的entityClassId
   **/
  private long entityClassId;
  private String entityClassCode;
  /**
   * 拆分索引的字段名
   **/
  private String segmentFieldName;
  /**
   * 租户code标识
   **/
  private String tenantCode;
  /**
   * 当业务字段为字符串日期时，使用传入的字符串格式对时间字符串进行格式化
   **/
  private String segmentDateFormat;
  /**
   * 是否开启分割索引
   **/
  private boolean enableSegment;
  /**
   * 是否同步至elastic
   **/
  private boolean enableSync;
  /**
   * 索引拆分的策略模式
   **/
  private SegmentIndexRule segmentRule;

  /**
   * 字段类型
   **/
  private SegmentFieldType segmentFieldType;
}
