package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;

import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.ultraman.adapter.elasticsearch.query.ElasticCustomShuttle;
import com.xforceplus.ultraman.adapter.elasticsearch.service.ManageBocpMetadataService;
import com.xforceplus.ultraman.metadata.engine.EntityClassEngine;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.plus.storage.pojo.dto.select.SelectConfig;
import com.xforceplus.ultraman.sdk.core.calcite.oqs.DataQueryProvider;
import com.xforceplus.ultraman.sdk.core.config.ExecutionConfig;
import com.xforceplus.ultraman.sdk.core.utils.MasterStorageHelper;
import com.xforceplus.ultraman.sdk.infra.metrics.MetricsDefine;
import io.micrometer.core.annotation.Timed;
import io.vavr.Tuple2;
import lombok.extern.slf4j.Slf4j;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Pair;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;

import javax.sql.DataSource;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

@Slf4j
public class ElasticSearchQueryMockFastProvider implements
        DataQueryProvider {

    private CloseableHttpAsyncClient client ;

    private String query2 = "{\"query\":{\"constant_score\":{\"filter\":{\"bool\":{\"must\":[{\"term\":{\"ext19\":{\"value\":\"是\",\"case_insensitive\":true}}},{\"term\":{\"is_check\":true}},{\"exists\":{\"field\":\"create_time\"}}]}}}},\"fields\":[\"invoice_type\",\"create_time\",\"update_user_id\",\"delete_flag\",\"invoice_code\",\"black_status\",\"check_user_id\",\"check_user_name\",\"id\",\"auth_style\",\"auth_status\",\"hang_status\",\"compliance_status\",\"no_auth_reason\",\"create_user_id\",\"sign_for_status\",\"update_user_name\",\"auth_tax_period\",\"charge_up_no\",\"invoice_orig\",\"payment_status\",\"purchaser_bank_name_account\",\"turn_out_amount\",\"retreat_status\",\"tenant_code\",\"charge_up_status\",\"area_code\",\"audit_time\",\"amount_with_tax\",\"auth_bussi_date\",\"area_name\",\"seller_tax_no\",\"invoice_status\",\"invoice_no\",\"org_id\",\"reserve_amount_without_tax\",\"invoicer_name\",\"paper_drew_date\",\"audit_status\",\"reserve_amount_with_tax\",\"payment_date\",\"purchaser_tax_no\",\"reserve_tax_amount\",\"tenant_name\",\"hang_remark\",\"check_code\",\"seller_bank_name_account\",\"ext8\",\"checker_name\",\"machine_code\",\"verify_time\",\"turn_out_status\",\"purchaser_name\",\"verify_number\",\"seller_name\",\"ext15\",\"origin_invoice_no\",\"ext19\",\"el_time\",\"cashier_name\",\"tax_amount\",\"issue_name\",\"invoice_remark\",\"purchaser_addr_tel\",\"is_check\",\"issue_tax_no\",\"ext7\",\"seller_addr_tel\",\"recog_user_name\",\"data_status\",\"purchaser_no\",\"ext9\",\"issue_flag\",\"purchaser_company_id\",\"invoice_business_type\",\"verify_user_id\",\"ext10\",\"special_invoice_flag\",\"verify_remark\",\"invoice_color\",\"origin_invoice_code\",\"verify_sign_status\",\"sale_list_flag\",\"payment_batch_no\",\"ext3\",\"ext13\",\"ext16\",\"ext4\",\"ext25\",\"tax_task_id\",\"verify_user_name\",\"ext11\",\"ext17\",\"ext5\",\"ext6\",\"verify_status\",\"recog_time\",\"is_auto_check\",\"ext12\",\"org_name\",\"tax_rate\",\"ext23\",\"ext24\",\"ncp_handle_user_name\",\"recog_status\",\"turn_out_type\",\"hang_time\",\"is_offline_check\",\"match_time\",\"charge_up_amount\",\"area_type\",\"red_status\",\"is_not_check\",\"purchaser_address\",\"seller_external_code\",\"ext14\",\"is_cancel_check\",\"seller_address\",\"purchaser_tel\",\"ext37\",\"sale_confirm_period\",\"ncp_part_amount\",\"seller_bank_name\",\"ext21\",\"ncp_jjkc_submit_time\",\"sale_confirm_status\",\"invoice_category\",\"ext22\",\"turn_out_remark\",\"no_compliance_type\",\"purchaser_bank_name\",\"match_amount\",\"is_cancelled_check\",\"red_notification_no\",\"el_sync_flag\",\"report_status\",\"purchaser_bank_account\",\"payment_user_name\",\"biz_tag3\",\"report_no\",\"follow_up_time\",\"report_time\",\"system_source\",\"ext29\",\"reopen_invoice_code\",\"recog_batch_no\",\"rms_code\",\"exception_time\",\"ncp_handle_time\",\"ncp_type\",\"charge_up_person\",\"seller_bank_account\",\"ncp_handle_type\",\"ext34\",\"ext36\",\"reimbursement_status\",\"recog_user_id\",\"entry_user_name\",\"biz_tag2\",\"purchaser_external_code\",\"ncp_jjkc_current_tax_amount\",\"reopen_invoice_no\",\"ncp_jjkc_submit_remark\",\"seller_no\",\"ncp_jjkc_submit_status\",\"function_group_way\",\"jv_code\",\"store_code\",\"ncp_handle_status\",\"risk_handle_status\",\"follow_up_remark\",\"area\",\"list_import_user\",\"retreat_time\",\"un_certified_reason\",\"is_repeat\",\"follow_up_status\",\"market\",\"un_certified_remark\",\"biz_tag1\",\"ext27\",\"auth_cancel_time\",\"entry_tab_status\",\"hang_user\",\"import_cert_no\",\"ext28\",\"ext35\",\"ncp_manage_status\",\"business_control_status\",\"tax_paid_proof\",\"tonnage\",\"is_tax_cancel_auth\",\"function_group\",\"vehicle_type\",\"max_capacity\",\"ncp_jjkc_auth_use\",\"exception_create_user\",\"vehicle_brand\",\"ncp_jjkc_status\",\"auth_request_time\",\"waybill_no\",\"ext26\",\"engine_no\",\"origin_all_electric_invoice_no\",\"ext33\",\"jv_pc\",\"ncp_jjkc_tax_amount\",\"actual_auth_way\",\"ncp_jjkc_left_tax_amount\",\"seller_company_id\",\"ncp_jjkc_accum_tax_amount\",\"send_exception_remark\",\"follow_up_user\",\"recog_sheet\",\"tax_auth_code\",\"risk_invoice_category\",\"is_send_exception\",\"is_need_auth\",\"production_area\",\"vehicle_no\",\"organization_code\",\"last_modify_time\",\"cert_no\",\"inspection_no\",\"tax_cancel_auth_time\",\"seller_sync_time\",\"tenant_id\",\"update_time\",\"create_user_name\",\"check_time\",\"auth_use\",\"auth_remark\",\"effective_tax_amount\",\"cooperate_flag\",\"retreat_remark\",\"sign_for_time\",\"charge_up_period\",\"payment_no\",\"black_remark\",\"turn_out_period\",\"audit_name\",\"audit_remark\",\"amount_without_tax\",\"cipher_text\",\"ext1\",\"ext2\",\"ext18\",\"ext20\",\"match_status\",\"org_code\",\"all_electric_invoice_no\",\"is_intercept\",\"payment_amount\",\"seller_tel\",\"sale_confirm_no\",\"red_time\",\"ncp_handle_remark\",\"entry_status\",\"entry_time\",\"entry_remark\",\"ext30\",\"ext31\",\"ext32\",\"reverse_list\",\"list_import_time\",\"tax_auth_name\",\"data_sharding\",\"invoiceviewandinvoiceverifyrelation_id\",\"invoiceviewandinvoicebusinessrelation_id\",\"companyandinvoiceviewrelation_id\",\"invoiceviewandinvoicemainrelation_id\",\"invoiceviewandinvoiceauthrelation_id\"],\"script_fields\":{\"biz_order_no\":{\"script\":\"params._source['biz_order_no@raw']\"},\"recog_order_no\":{\"script\":\"params._source['recog_order_no@raw']\"},\"origin_biz_order_no\":{\"script\":\"params._source['origin_biz_order_no@raw']\"}},\"size\":20,\"_source\":false}";

    public ElasticSearchQueryMockFastProvider() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom()
                .setConnectTimeout(100000)
                .setSocketTimeout(100000);

        CredentialsProvider credentialsProvider = new BasicCredentialsProvider();

        String userName = "dvlp_manual";
        String password = "gImPr5PfZrLeJntQ5ed88NMrxeQ9";
        if (null != userName && !userName.isEmpty() &&
                null != password && !password.isEmpty()) {
            credentialsProvider.setCredentials(AuthScope.ANY,
                    new UsernamePasswordCredentials(userName, password));
        }
        client =  HttpAsyncClientBuilder.create()
                .setDefaultRequestConfig(requestConfigBuilder.build())
                .setMaxConnTotal(10000)
                .setMaxConnPerRoute(1000)
                .setDefaultCredentialsProvider(credentialsProvider)
                .build();

        client.start();
    }

    @Override
    public QueryProviderType type() {
        return QueryProviderType.INDEX;
    }

    @Override
    public List<Object> query(String app, IEntityClass entityClass
            , String profile, RelDataType type, List<RexNode> ops
            , List<Map.Entry<String, Tuple2<StructKind, Class>>> fields, List<Pair<RexNode, String>> projects, List<Map.Entry<String, RelFieldCollation.Direction>> sort, Long offset, Long fetch, List<String> groupBy, List<AggregateCall> aggs, List<RelHint> hints, RelNode rawTree, DataContext dataContext) {
        try {
            HttpHost host = new HttpHost("es-cn-zxu3ai8vw000hsa9i.elasticsearch.aliyuncs.com", 9200);
            HttpPost httpPost = new HttpPost();
            httpPost.setURI(URI.create("/purchaserinvoicesaas_invoiceview/_search"));
            httpPost.setEntity(new StringEntity(query2));
            httpPost.setHeader("Content-type", "application/json");
            Future<HttpResponse> execute = client.execute(host, httpPost, new FutureCallback<HttpResponse>() {
                @Override
                public void completed(HttpResponse result) {
                    System.out.println(result);
                }

                @Override
                public void failed(Exception ex) {
                    ex.printStackTrace();
                }

                @Override
                public void cancelled() {
                    System.out.println("cancelled");
                }
            });

            execute.get();
        } catch (Throwable throwable) {
            
        }
        
        return Collections.emptyList();
    }
}

