package com.xforceplus.ultraman.adapter.elasticsearch.query.utils;

import com.google.common.collect.ImmutableList;
import com.xforceplus.ultraman.metadata.engine.EntityClassGroup;
import com.xforceplus.ultraman.metadata.entity.FieldType;
import com.xforceplus.ultraman.metadata.entity.IEntityField;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.*;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ElasticSearchRelToSqlConverter extends RelToSqlConverter {

    private EntityClassGroup entityClassGroup;


    /**
     * Creates a RelToSqlConverter.
     *
     * @param dialect
     */
    public ElasticSearchRelToSqlConverter(SqlDialect dialect, EntityClassGroup entityClassGroup) {
        super(dialect);
        this.entityClassGroup = entityClassGroup;
    }

    private void parseCorrelTable(RelNode relNode, Result x) {
        for (CorrelationId id : relNode.getVariablesSet()) {
            correlTableMap.put(id, x.qualifiedContext());
        }
    }

    private SqlNode castNullType(SqlNode nullLiteral, RelDataType type) {
        final SqlNode typeNode = dialect.getCastSpec(type);
        if (typeNode == null) {
            return nullLiteral;
        }
        return SqlStdOperatorTable.CAST.createCall(POS, nullLiteral, typeNode);
    }

    @Override
    public Result visit(Project e) {
        // If the input is a Sort, wrap SELECT is not required.
        final Result x;
        if (e.getInput() instanceof Sort) {
            x = visitInput(e, 0);
        } else {
            x = visitInput(e, 0, Clause.SELECT);
        }
        parseCorrelTable(e, x);
        final Builder builder = x.builder(e);
        if (!isStar(e.getProjects(), e.getInput().getRowType(), e.getRowType())) {
            final List<SqlNode> selectList = new ArrayList<>();
            for (RexNode ref : e.getProjects()) {
                SqlNode sqlExpr = builder.context.toSql(null, ref);

                if (sqlExpr instanceof SqlIdentifier) {
                    ImmutableList<String> names = ((SqlIdentifier) sqlExpr).names;
                    String value;
                    if(names.size() > 1) {
                        value = ((SqlIdentifier) sqlExpr).names.get(1);
                    } else {
                        value =  ((SqlIdentifier) sqlExpr).getSimple();
                    }
                    Optional<IEntityField> field = entityClassGroup.field(value);
                    if (field.isPresent()) {
                        if (field.get().type() == FieldType.STRINGS) {
                            List<SqlNode> as = new ArrayList<>();
                            //as.add(new SqlIdentifier(value.concat("@raw"), SqlParserPos.ZERO));
                            //as.add(new SqlIdentifier(value, SqlParserPos.ZERO));
                            //sqlExpr = new SqlBasicCall(new SqlAsOperator(), as, SqlParserPos.ZERO);
                            sqlExpr = new SqlIdentifier(value.concat("@raw"), SqlParserPos.ZERO);
                        }
                    }
                }

                if (SqlUtil.isNullLiteral(sqlExpr, false)) {
                    final RelDataTypeField field =
                            e.getRowType().getFieldList().get(selectList.size());
                    sqlExpr = castNullType(sqlExpr, field.getType());
                }
                addSelect(selectList, sqlExpr, e.getRowType());
            }

            builder.setSelect(new SqlNodeList(selectList, POS));
        }
        return builder.result();
    }
}