package com.xforceplus.ultraman.adapter.elasticsearch.service;

import com.xforceplus.ultraman.metadata.entity.IEntityField;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface IndexOperation {

  boolean indexExists(String indexName, String profile);
  
  boolean indexExists(String profile, String...indexNames);
  
  Set<String> getAllIndex(String profile);

  boolean putMapping(String indexName, Collection<IEntityField> allField, String prefixName, String profile);

  boolean joinMapping(String indexName, Set<String> relastions, String entityClassCode, String profile);

  boolean createIndexAndCreateMapping(String indexName, Collection<IEntityField> allFields, String profile);
}
