package com.xforceplus.ultraman.adapter.elasticsearch.service;

import com.xforceplus.ultraman.adapter.elasticsearch.query.dto.ElasticTenantProfile;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import io.vavr.Tuple2;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ManageBocpMetabaseService
 * @description:
 * @author: WanYi
 * @create: 2023-08-14 17:14
 * @Version 1.0
 **/
public interface ManageBocpMetadataService {

  void updateMetadataCache(Collection<ElasticTenantProfile> elasticTenantProfiles, IEntityClass iEntityClass, List<Tuple2<String, String>> errors);

  void buildRedundantFields(String profile, IEntityClass iEntityClass, String indexName, List<Tuple2<String, String>> errors);

  void createOrUpdateIndexMapping(List<Tuple2<String, String>> errors, IEntityClass iEntityClass, String tenantCode, String indexName);

  String getWriteSegmentIndex(String profile, IEntityClass iEntityClass, Map<String, Object> attribute);

  Tuple2<String, String> getSearchSegmentIndex(String profile, String entityClassCode);

  String getIndexPrefix(String profile, String appCode);

  List<String> getEntityClassMappingIndexs(String profile, IEntityClass iEntityClass);

  boolean checkPassage(String profile, IEntityClass iEntityClass);

  void setLoadFinish(boolean loadFinish);

  boolean getLoadFinish();
  
  void initSync();
}
